/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mongodb.client.MongoClient;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.mongodb.MongoClientConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoClientConfig", generator="Immutables")
@Immutable
public final class ImmutableMongoClientConfig
implements MongoClientConfig {
    @jakarta.annotation.Nullable
    private final String connectionString;
    @jakarta.annotation.Nullable
    private final String databaseName;
    @jakarta.annotation.Nullable
    private final MongoClient client;

    private ImmutableMongoClientConfig(@jakarta.annotation.Nullable String connectionString, @jakarta.annotation.Nullable String databaseName, @jakarta.annotation.Nullable MongoClient client) {
        this.connectionString = connectionString;
        this.databaseName = databaseName;
        this.client = client;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    @jakarta.annotation.Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    @jakarta.annotation.Nullable
    public MongoClient getClient() {
        return this.client;
    }

    @Override
    public final ImmutableMongoClientConfig withConnectionString(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.connectionString, value)) {
            return this;
        }
        return new ImmutableMongoClientConfig(value, this.databaseName, this.client);
    }

    @Override
    public final ImmutableMongoClientConfig withDatabaseName(@jakarta.annotation.Nullable String value) {
        if (Objects.equals(this.databaseName, value)) {
            return this;
        }
        return new ImmutableMongoClientConfig(this.connectionString, value, this.client);
    }

    @Override
    public final ImmutableMongoClientConfig withClient(@jakarta.annotation.Nullable MongoClient value) {
        if (this.client == value) {
            return this;
        }
        return new ImmutableMongoClientConfig(this.connectionString, this.databaseName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoClientConfig && this.equalTo(0, (ImmutableMongoClientConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoClientConfig another) {
        return Objects.equals(this.connectionString, another.connectionString) && Objects.equals(this.databaseName, another.databaseName) && Objects.equals(this.client, another.client);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.connectionString);
        h += (h << 5) + Objects.hashCode(this.databaseName);
        h += (h << 5) + Objects.hashCode(this.client);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoClientConfig").omitNullValues().add("connectionString", (Object)this.connectionString).add("databaseName", (Object)this.databaseName).add("client", (Object)this.client).toString();
    }

    public static ImmutableMongoClientConfig copyOf(MongoClientConfig instance) {
        if (instance instanceof ImmutableMongoClientConfig) {
            return (ImmutableMongoClientConfig)instance;
        }
        return ImmutableMongoClientConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoClientConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String connectionString;
        @Nullable
        private String databaseName;
        @Nullable
        private MongoClient client;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoClientConfig instance) {
            MongoClient clientValue;
            String databaseNameValue;
            Objects.requireNonNull(instance, "instance");
            String connectionStringValue = instance.getConnectionString();
            if (connectionStringValue != null) {
                this.connectionString(connectionStringValue);
            }
            if ((databaseNameValue = instance.getDatabaseName()) != null) {
                this.databaseName(databaseNameValue);
            }
            if ((clientValue = instance.getClient()) != null) {
                this.client(clientValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionString(@jakarta.annotation.Nullable String connectionString) {
            this.connectionString = connectionString;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder databaseName(@jakarta.annotation.Nullable String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder client(@jakarta.annotation.Nullable MongoClient client) {
            this.client = client;
            return this;
        }

        public ImmutableMongoClientConfig build() {
            return new ImmutableMongoClientConfig(this.connectionString, this.databaseName, this.client);
        }
    }
}

