/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.mongodb;

import com.google.common.collect.Maps;
import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteException;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.projectnessie.nessie.relocated.protobuf.InvalidProtocolBufferException;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.events.AdapterEventConsumer;
import org.projectnessie.versioned.persist.adapter.serialize.ProtoSerialization;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.mongodb.MongoDatabaseClient;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapter;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;

public class MongoDatabaseAdapter
extends NonTransactionalDatabaseAdapter<NonTransactionalDatabaseAdapterConfig> {
    private static final String ID_PROPERTY_NAME = "_id";
    private static final String ID_REPO_NAME = "repo";
    private static final String ID_HASH_NAME = "hash";
    private static final String ID_REF_NAME = "ref";
    private static final String ID_STRIPE = "stripe";
    private static final String ID_REPO_PATH = "_id.repo";
    private static final String DATA_PROPERTY_NAME = "data";
    private static final String GLOBAL_ID_PROPERTY_NAME = "globalId";
    private static final String LOCK_ID_PROPERTY_NAME = "lockId";
    private final String repositoryId;
    private final String globalPointerKey;
    private final MongoDatabaseClient client;

    protected MongoDatabaseAdapter(NonTransactionalDatabaseAdapterConfig config, MongoDatabaseClient client, AdapterEventConsumer eventConsumer) {
        super(config, eventConsumer);
        Objects.requireNonNull(client, "MongoDatabaseClient cannot be null");
        this.client = client;
        this.repositoryId = config.getRepositoryId();
        Objects.requireNonNull(this.repositoryId, "Repository ID cannot be null");
        this.globalPointerKey = this.repositoryId;
    }

    protected void doEraseRepo() {
        this.client.getGlobalPointers().deleteMany(Filters.eq((Object)this.globalPointerKey));
        this.client.getRepoDesc().deleteMany(Filters.eq((Object)this.globalPointerKey));
        Bson idPrefixFilter = Filters.eq((String)ID_REPO_PATH, (Object)this.repositoryId);
        this.client.allWithCompositeId().forEach(coll -> coll.deleteMany(idPrefixFilter));
    }

    private Document toId(Hash id) {
        Document idDoc = new Document();
        idDoc.put(ID_REPO_NAME, (Object)this.repositoryId);
        idDoc.put(ID_HASH_NAME, (Object)id.asString());
        return idDoc;
    }

    private Document toId(String id) {
        Document idDoc = new Document();
        idDoc.put(ID_REPO_NAME, (Object)this.repositoryId);
        idDoc.put(ID_REF_NAME, (Object)id);
        return idDoc;
    }

    private Document toId(int id) {
        Document idDoc = new Document();
        idDoc.put(ID_REPO_NAME, (Object)this.repositoryId);
        idDoc.put(ID_STRIPE, (Object)id);
        return idDoc;
    }

    private List<Document> toIdsFromHashes(Collection<Hash> ids) {
        return ids.stream().map(this::toId).collect(Collectors.toList());
    }

    private Document toDoc(Hash id, byte[] data) {
        return MongoDatabaseAdapter.toDoc(this.toId(id), data);
    }

    private static Document toDoc(Document id, byte[] data) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)id);
        doc.put(DATA_PROPERTY_NAME, (Object)data);
        return doc;
    }

    private Document toDoc(AdapterTypes.GlobalStatePointer pointer) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)this.globalPointerKey);
        doc.put(DATA_PROPERTY_NAME, (Object)pointer.toByteArray());
        doc.put(GLOBAL_ID_PROPERTY_NAME, (Object)pointer.getGlobalId().toByteArray());
        return doc;
    }

    private Document toDoc(AdapterTypes.RepoProps pointer) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)this.globalPointerKey);
        doc.put(DATA_PROPERTY_NAME, (Object)pointer.toByteArray());
        return doc;
    }

    private Document toDoc(AdapterTypes.NamedReference pointer) {
        Document doc = new Document();
        doc.put(ID_PROPERTY_NAME, (Object)this.toId(pointer.getName()));
        doc.put(DATA_PROPERTY_NAME, (Object)pointer.toByteArray());
        doc.put(ID_HASH_NAME, (Object)pointer.getRef().getHash().toByteArray());
        return doc;
    }

    private void insert(MongoCollection<Document> collection, Hash id, byte[] data) throws ReferenceConflictException {
        MongoDatabaseAdapter.insert(collection, this.toDoc(id, data));
    }

    private static void insert(MongoCollection<Document> collection, Document doc) throws ReferenceConflictException {
        InsertOneResult result;
        try {
            result = collection.insertOne((Object)doc);
        }
        catch (MongoServerException e) {
            if (MongoDatabaseAdapter.isDuplicateKeyError(e)) {
                ReferenceConflictException ex = DatabaseAdapterUtil.hashCollisionDetected();
                ex.initCause((Throwable)e);
                throw ex;
            }
            throw e;
        }
        MongoDatabaseAdapter.verifyAcknowledged(result, collection);
    }

    private static void insert(MongoCollection<Document> collection, List<Document> docs) throws ReferenceConflictException {
        InsertManyResult result;
        if (docs.isEmpty()) {
            return;
        }
        try {
            result = collection.insertMany(docs);
        }
        catch (MongoServerException e) {
            if (MongoDatabaseAdapter.isDuplicateKeyError(e)) {
                ReferenceConflictException ex = DatabaseAdapterUtil.hashCollisionDetected();
                ex.initCause((Throwable)e);
                throw ex;
            }
            throw e;
        }
        MongoDatabaseAdapter.verifyAcknowledged(result, collection);
    }

    private void delete(MongoCollection<Document> collection, Collection<Hash> ids) {
        DeleteResult result = collection.deleteMany(Filters.in((String)ID_PROPERTY_NAME, this.toIdsFromHashes(ids)));
        MongoDatabaseAdapter.verifyAcknowledged(result, collection);
    }

    private static <ID> byte[] loadById(MongoCollection<Document> collection, ID id) {
        Document doc = (Document)collection.find(Filters.eq(id)).first();
        if (doc == null) {
            return null;
        }
        Binary data = (Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class);
        if (data == null) {
            return null;
        }
        return data.getData();
    }

    private <T> T loadById(MongoCollection<Document> collection, Hash id, ProtoSerialization.Parser<T> parser) {
        return MongoDatabaseAdapter.loadByIdGeneric(collection, this.toId(id), parser);
    }

    private <T> T loadById(MongoCollection<Document> collection, String ref, ProtoSerialization.Parser<T> parser) {
        return MongoDatabaseAdapter.loadByIdGeneric(collection, this.toId(ref), parser);
    }

    private <T> T loadById(MongoCollection<Document> collection, int stripe, ProtoSerialization.Parser<T> parser) {
        return MongoDatabaseAdapter.loadByIdGeneric(collection, this.toId(stripe), parser);
    }

    private static <T, ID> T loadByIdGeneric(MongoCollection<Document> collection, ID id, ProtoSerialization.Parser<T> parser) {
        byte[] data = MongoDatabaseAdapter.loadById(collection, id);
        if (data == null) {
            return null;
        }
        try {
            return (T)parser.parse(data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    private <T> List<T> fetchMappedPage(MongoCollection<Document> collection, List<Hash> hashes, Function<Document, T> mapper) {
        List ids = hashes.stream().map(this::toId).collect(Collectors.toList());
        FindIterable docs = collection.find(Filters.in((String)ID_PROPERTY_NAME, ids)).limit(hashes.size());
        HashMap loaded = Maps.newHashMapWithExpectedSize((int)hashes.size());
        for (Document doc : docs) {
            loaded.put(this.idAsHash(doc), doc);
        }
        ArrayList<Object> result = new ArrayList<Object>(hashes.size());
        for (Hash hash : hashes) {
            Object element = null;
            Document document = (Document)loaded.get(hash);
            if (document != null) {
                element = mapper.apply(document);
            }
            result.add(element);
        }
        return result;
    }

    private <T> List<T> fetchPage(MongoCollection<Document> collection, List<Hash> hashes, ProtoSerialization.Parser<T> parser) {
        return this.fetchMappedPage(collection, hashes, document -> {
            try {
                byte[] data = MongoDatabaseAdapter.data(document);
                return parser.parse(data);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    protected CommitLogEntry doFetchFromCommitLog(NonTransactionalOperationContext ctx, Hash hash) {
        return (CommitLogEntry)this.loadById(this.client.getCommitLog(), hash, ProtoSerialization::protoToCommitLogEntry);
    }

    private Hash idAsHash(Document doc) {
        return Hash.of((String)this.idAsString(doc));
    }

    private String idAsString(Document doc) {
        Document id = (Document)doc.get((Object)ID_PROPERTY_NAME, Document.class);
        String repo = id.getString((Object)ID_REPO_NAME);
        if (!this.repositoryId.equals(repo)) {
            throw new IllegalStateException(String.format("Repository mismatch for id '%s' (expected repository ID: '%s')", id, this.repositoryId));
        }
        return id.getString((Object)ID_HASH_NAME);
    }

    private static byte[] data(Document doc) {
        return ((Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class)).getData();
    }

    protected List<CommitLogEntry> doFetchMultipleFromCommitLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.client.getCommitLog(), hashes, ProtoSerialization::protoToCommitLogEntry);
    }

    protected RepoDescription doFetchRepositoryDescription(NonTransactionalOperationContext ctx) {
        return (RepoDescription)MongoDatabaseAdapter.loadByIdGeneric(this.client.getRepoDesc(), this.globalPointerKey, ProtoSerialization::protoToRepoDescription);
    }

    protected boolean doTryUpdateRepositoryDescription(NonTransactionalOperationContext ctx, RepoDescription expected, RepoDescription updateTo) {
        Document doc = this.toDoc(ProtoSerialization.toProto((RepoDescription)updateTo));
        if (expected != null) {
            byte[] expectedBytes = ProtoSerialization.toProto((RepoDescription)expected).toByteArray();
            return MongoDatabaseAdapter.verifySuccessfulUpdate(this.client.getRepoDesc(), coll -> coll.replaceOne(Filters.and((Bson[])new Bson[]{Filters.eq((Object)this.globalPointerKey), Filters.eq((String)DATA_PROPERTY_NAME, (Object)expectedBytes)}), (Object)doc));
        }
        try {
            return this.client.getRepoDesc().insertOne((Object)doc).wasAcknowledged();
        }
        catch (MongoServerException e) {
            if (MongoDatabaseAdapter.isDuplicateKeyError(e)) {
                return false;
            }
            throw e;
        }
    }

    protected List<AdapterTypes.NamedReference> doFetchNamedReference(NonTransactionalOperationContext ctx, List<String> refNames) {
        List idDocs = refNames.stream().map(this::toId).collect(Collectors.toList());
        ArrayList<AdapterTypes.NamedReference> result = new ArrayList<AdapterTypes.NamedReference>(refNames.size());
        this.client.getRefHeads().find(Filters.in((String)ID_PROPERTY_NAME, idDocs)).limit(idDocs.size()).map(doc -> ((Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class)).getData()).map(data -> {
            try {
                return AdapterTypes.NamedReference.parseFrom((byte[])data);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }).forEach(result::add);
        return result;
    }

    protected boolean doCreateNamedReference(NonTransactionalOperationContext ctx, AdapterTypes.NamedReference namedReference) {
        byte[] existing = (byte[])this.loadById(this.client.getRefHeads(), namedReference.getName(), bytes -> bytes);
        if (existing != null) {
            return false;
        }
        try {
            MongoDatabaseAdapter.verifyAcknowledged(this.client.getRefHeads().insertOne((Object)this.toDoc(namedReference)), this.client.getRefHeads());
            return true;
        }
        catch (MongoServerException e) {
            if (MongoDatabaseAdapter.isDuplicateKeyError(e)) {
                return false;
            }
            throw e;
        }
    }

    protected boolean doDeleteNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead) {
        return MongoDatabaseAdapter.verifyAcknowledged(this.client.getRefHeads().deleteOne(Filters.and((Bson[])new Bson[]{Filters.eq((Object)this.toId(ref.getName())), Filters.eq((String)ID_HASH_NAME, (Object)refHead.getHash().toByteArray())})), this.client.getRefHeads()).getDeletedCount() == 1L;
    }

    protected void doAddToNamedReferences(NonTransactionalOperationContext ctx, Stream<NamedRef> refStream, int addToSegment) {
        MongoDatabaseAdapter.verifyAcknowledged(this.client.getRefNames().updateOne(Filters.eq((Object)this.toId(addToSegment)), Updates.addEachToSet((String)DATA_PROPERTY_NAME, refStream.map(NamedRef::getName).collect(Collectors.toList())), new UpdateOptions().upsert(true)), this.client.getRefNames());
    }

    protected void doRemoveFromNamedReferences(NonTransactionalOperationContext ctx, NamedRef ref, int removeFromSegment) {
        MongoDatabaseAdapter.verifyAcknowledged(this.client.getRefNames().updateOne(Filters.eq((Object)this.toId(removeFromSegment)), Updates.pull((String)DATA_PROPERTY_NAME, (Object)ref.getName()), new UpdateOptions().upsert(true)), this.client.getRefNames());
    }

    protected boolean doUpdateNamedReference(NonTransactionalOperationContext ctx, NamedRef ref, AdapterTypes.RefPointer refHead, Hash newHead) {
        Document newDoc = this.toDoc(AdapterTypes.NamedReference.newBuilder().setName(ref.getName()).setRef(refHead.toBuilder().setHash(newHead.asBytes())).build());
        return MongoDatabaseAdapter.verifySuccessfulUpdate(this.client.getRefHeads(), coll -> coll.updateOne(Filters.and((Bson[])new Bson[]{Filters.eq((Object)this.toId(ref.getName())), Filters.eq((String)ID_HASH_NAME, (Object)refHead.getHash().toByteArray())}), (Bson)new Document("$set", (Object)newDoc)));
    }

    protected int entitySize(CommitLogEntry entry) {
        return ProtoSerialization.toProto((CommitLogEntry)entry).getSerializedSize();
    }

    protected int entitySize(KeyListEntry entry) {
        return ProtoSerialization.toProto((KeyListEntry)entry).getSerializedSize();
    }

    protected Stream<KeyListEntity> doFetchKeyLists(NonTransactionalOperationContext ctx, List<Hash> keyListsIds) {
        return this.fetchMappedPage(this.client.getKeyLists(), keyListsIds, document -> {
            Hash hash = this.idAsHash((Document)document);
            KeyList keyList = ProtoSerialization.protoToKeyList((byte[])MongoDatabaseAdapter.data(document));
            return KeyListEntity.of((Hash)hash, (KeyList)keyList);
        }).stream();
    }

    protected void doWriteIndividualCommit(NonTransactionalOperationContext ctx, CommitLogEntry entry) throws ReferenceConflictException {
        this.insert(this.client.getCommitLog(), entry.getHash(), ProtoSerialization.toProto((CommitLogEntry)entry).toByteArray());
    }

    protected void doWriteMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        List<Document> docs = entries.stream().map(e -> this.toDoc(e.getHash(), ProtoSerialization.toProto((CommitLogEntry)e).toByteArray())).collect(Collectors.toList());
        MongoDatabaseAdapter.insert(this.client.getCommitLog(), docs);
    }

    protected void doUpdateMultipleCommits(NonTransactionalOperationContext ctx, List<CommitLogEntry> entries) throws ReferenceNotFoundException {
        List requests = entries.stream().map(e -> this.toDoc(e.getHash(), ProtoSerialization.toProto((CommitLogEntry)e).toByteArray())).map(d -> new UpdateOneModel(Filters.eq((Object)d.get((Object)ID_PROPERTY_NAME)), (Bson)new Document("$set", d), new UpdateOptions().upsert(false))).collect(Collectors.toList());
        BulkWriteResult result = this.client.getCommitLog().bulkWrite(requests);
        MongoDatabaseAdapter.verifyAcknowledged(result, this.client.getCommitLog());
        if (result.getMatchedCount() != entries.size()) {
            throw new ReferenceNotFoundException("");
        }
    }

    protected void doWriteKeyListEntities(NonTransactionalOperationContext ctx, List<KeyListEntity> newKeyListEntities) {
        try {
            List<Document> docs = newKeyListEntities.stream().map(keyList -> this.toDoc(keyList.getId(), ProtoSerialization.toProto((KeyList)keyList.getKeys()).toByteArray())).collect(Collectors.toList());
            MongoDatabaseAdapter.insert(this.client.getKeyLists(), docs);
        }
        catch (ReferenceConflictException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void unsafeWriteGlobalPointer(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) {
        Document doc = this.toDoc(pointer);
        MongoDatabaseAdapter.verifyAcknowledged(this.client.getGlobalPointers().updateOne(Filters.eq((Object)this.globalPointerKey), (Bson)new Document("$set", (Object)doc), new UpdateOptions().upsert(true)), this.client.getGlobalPointers());
    }

    protected boolean doGlobalPointerCas(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer expected, AdapterTypes.GlobalStatePointer newPointer) {
        Document doc = this.toDoc(newPointer);
        byte[] expectedGlobalId = expected.getGlobalId().toByteArray();
        return MongoDatabaseAdapter.verifySuccessfulUpdate(this.client.getGlobalPointers(), coll -> coll.replaceOne(Filters.and((Bson[])new Bson[]{Filters.eq((Object)this.globalPointerKey), Filters.eq((String)GLOBAL_ID_PROPERTY_NAME, (Object)expectedGlobalId)}), (Object)doc));
    }

    protected void doCleanUpCommitCas(NonTransactionalOperationContext ctx, Set<Hash> branchCommits, Set<Hash> newKeyLists) {
        this.delete(this.client.getCommitLog(), branchCommits);
        this.delete(this.client.getKeyLists(), newKeyLists);
    }

    protected List<AdapterTypes.ReferenceNames> doFetchReferenceNames(NonTransactionalOperationContext ctx, int segment, int prefetchSegments) {
        List idDocs = IntStream.rangeClosed(segment, segment + prefetchSegments).mapToObj(this::toId).collect(Collectors.toList());
        AdapterTypes.ReferenceNames[] result = new AdapterTypes.ReferenceNames[1 + prefetchSegments];
        this.client.getRefNames().find(Filters.in((String)ID_PROPERTY_NAME, idDocs)).forEach(doc -> {
            AdapterTypes.ReferenceNames refNames;
            Integer stripe = (Integer)((Document)doc.get((Object)ID_PROPERTY_NAME, Document.class)).get((Object)ID_STRIPE, Integer.class);
            result[stripe.intValue() - segment] = refNames = AdapterTypes.ReferenceNames.newBuilder().addAllRefNames((Iterable)doc.getList((Object)DATA_PROPERTY_NAME, String.class)).build();
        });
        return Arrays.asList(result);
    }

    protected AdapterTypes.GlobalStatePointer doFetchGlobalPointer(NonTransactionalOperationContext ctx) {
        return (AdapterTypes.GlobalStatePointer)MongoDatabaseAdapter.loadByIdGeneric(this.client.getGlobalPointers(), this.globalPointerKey, AdapterTypes.GlobalStatePointer::parseFrom);
    }

    protected AdapterTypes.GlobalStateLogEntry doFetchFromGlobalLog(NonTransactionalOperationContext ctx, Hash id) {
        return (AdapterTypes.GlobalStateLogEntry)this.loadById(this.client.getGlobalLog(), id, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected List<AdapterTypes.GlobalStateLogEntry> doFetchPageFromGlobalLog(NonTransactionalOperationContext ctx, List<Hash> hashes) {
        return this.fetchPage(this.client.getGlobalLog(), hashes, AdapterTypes.GlobalStateLogEntry::parseFrom);
    }

    protected Stream<CommitLogEntry> doScanAllCommitLogEntries(NonTransactionalOperationContext c) {
        Bson idPrefixFilter = Filters.eq((String)ID_REPO_PATH, (Object)this.repositoryId);
        FindIterable iter = this.client.getCommitLog().find(idPrefixFilter, Document.class).batchSize(((NonTransactionalDatabaseAdapterConfig)this.config).getCommitLogScanPrefetch());
        Spliterator split = iter.spliterator();
        return StreamSupport.stream(split, false).map(doc -> (Binary)doc.get((Object)DATA_PROPERTY_NAME, Binary.class)).map(Binary::getData).map(ProtoSerialization::protoToCommitLogEntry);
    }

    private static boolean isDuplicateKeyError(MongoServerException e) {
        if (e instanceof DuplicateKeyException) {
            return true;
        }
        if (e instanceof MongoWriteException) {
            MongoWriteException writeException = (MongoWriteException)e;
            return writeException.getError().getCategory() == ErrorCategory.DUPLICATE_KEY;
        }
        if (e instanceof MongoBulkWriteException) {
            MongoBulkWriteException writeException = (MongoBulkWriteException)e;
            for (BulkWriteError writeError : writeException.getWriteErrors()) {
                if (writeError.getCategory() != ErrorCategory.DUPLICATE_KEY) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean verifySuccessfulUpdate(MongoCollection<Document> mongoCollection, Function<MongoCollection<Document>, UpdateResult> updater) {
        UpdateResult result = updater.apply(mongoCollection);
        MongoDatabaseAdapter.verifyAcknowledged(result, mongoCollection);
        return result.getMatchedCount() == 1L && result.getModifiedCount() == 1L;
    }

    private static void verifyAcknowledged(InsertOneResult result, MongoCollection<Document> mongoCollection) {
        MongoDatabaseAdapter.verifyAcknowledged(result.wasAcknowledged(), mongoCollection);
    }

    private static void verifyAcknowledged(InsertManyResult result, MongoCollection<Document> mongoCollection) {
        MongoDatabaseAdapter.verifyAcknowledged(result.wasAcknowledged(), mongoCollection);
    }

    private static void verifyAcknowledged(BulkWriteResult result, MongoCollection<Document> mongoCollection) {
        MongoDatabaseAdapter.verifyAcknowledged(result.wasAcknowledged(), mongoCollection);
    }

    private static void verifyAcknowledged(UpdateResult result, MongoCollection<Document> mongoCollection) {
        MongoDatabaseAdapter.verifyAcknowledged(result.wasAcknowledged(), mongoCollection);
    }

    private static DeleteResult verifyAcknowledged(DeleteResult result, MongoCollection<Document> mongoCollection) {
        MongoDatabaseAdapter.verifyAcknowledged(result.wasAcknowledged(), mongoCollection);
        return result;
    }

    private static void verifyAcknowledged(boolean acknowledged, MongoCollection<Document> mongoCollection) {
        if (!acknowledged) {
            throw new IllegalStateException("Unacknowledged write to " + mongoCollection.getNamespace());
        }
    }
}

