/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.cache.ImmutableCacheConfig;

@Value.Immutable
public interface CacheConfig {
    public static final String INVALID_REFERENCE_NEGATIVE_TTL = "Cache reference-negative-TTL must only be present, if reference-TTL is configured, and must only be positive.";
    public static final String INVALID_REFERENCE_TTL = "Cache reference-TTL must be positive, if present.";

    public long capacityMb();

    public Optional<MeterRegistry> meterRegistry();

    public Optional<Duration> referenceTtl();

    public Optional<Duration> referenceNegativeTtl();

    @Value.Default
    default public LongSupplier clockNanos() {
        return System::nanoTime;
    }

    public static Builder builder() {
        return ImmutableCacheConfig.builder();
    }

    @Value.Check
    default public void check() {
        this.referenceTtl().ifPresent(ttl -> Preconditions.checkState((ttl.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)INVALID_REFERENCE_TTL));
        this.referenceNegativeTtl().ifPresent(ttl -> Preconditions.checkState((this.referenceTtl().isPresent() && ttl.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)INVALID_REFERENCE_NEGATIVE_TTL));
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder capacityMb(long var1);

        @CanIgnoreReturnValue
        public Builder meterRegistry(MeterRegistry var1);

        @CanIgnoreReturnValue
        public Builder referenceTtl(Duration var1);

        @CanIgnoreReturnValue
        public Builder referenceNegativeTtl(Duration var1);

        @CanIgnoreReturnValue
        public Builder clockNanos(LongSupplier var1);

        public CacheConfig build();
    }
}

