/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.function.Supplier;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.ImmutableEmptyIndexImpl;
import org.projectnessie.versioned.storage.common.indexes.IndexLoader;
import org.projectnessie.versioned.storage.common.indexes.LayeredIndexImpl;
import org.projectnessie.versioned.storage.common.indexes.LazyIndexImpl;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexImpl;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.indexes.StripedIndexImpl;

public final class StoreIndexes {
    private StoreIndexes() {
    }

    public static <V> StoreIndex<V> emptyImmutableIndex(ElementSerializer<V> serializer) {
        return new ImmutableEmptyIndexImpl<V>(serializer);
    }

    public static <V> StoreIndex<V> newStoreIndex(ElementSerializer<V> serializer) {
        return new StoreIndexImpl<V>(serializer);
    }

    public static <V> StoreIndex<V> deserializeStoreIndex(ByteString serialized, ElementSerializer<V> ser) {
        return StoreIndexImpl.deserializeStoreIndex(serialized.asReadOnlyByteBuffer(), ser);
    }

    public static <V> StoreIndex<V> lazyStoreIndex(Supplier<StoreIndex<V>> supplier, StoreKey firstKey, StoreKey lastKey) {
        return new LazyIndexImpl<V>(supplier, firstKey, lastKey);
    }

    public static <V> StoreIndex<V> lazyStoreIndex(Supplier<StoreIndex<V>> supplier) {
        return new LazyIndexImpl<V>(supplier, null, null);
    }

    public static <V> StoreIndex<V> layeredIndex(StoreIndex<V> reference, StoreIndex<V> updates) {
        return new LayeredIndexImpl<V>(reference, updates);
    }

    public static <V> StoreIndex<V> indexFromStripes(List<StoreIndex<V>> stripes) {
        StoreIndex[] stripesArr = stripes.toArray(new StoreIndex[0]);
        StoreKey[] firstLastKeys = new StoreKey[stripes.size() * 2];
        for (int i = 0; i < stripes.size(); ++i) {
            StoreIndex<V> stripe = stripes.get(i);
            StoreKey first = stripe.first();
            StoreKey last = stripe.last();
            Preconditions.checkArgument((first != null && last != null ? 1 : 0) != 0, (String)"Stipe #%s must not be empty, but is empty", (int)i);
            firstLastKeys[i * 2] = first;
            firstLastKeys[i * 2 + 1] = last;
        }
        return new StripedIndexImpl(stripesArr, firstLastKeys, IndexLoader.notLoading());
    }

    public static <V> StoreIndex<V> indexFromSplits(@Nonnull List<StoreIndex<V>> stripes, @Nonnull List<StoreKey> firstLastKeys, IndexLoader<V> indexLoader) {
        StoreIndex[] stripesArr = stripes.toArray(new StoreIndex[0]);
        StoreKey[] firstLastKeysArr = firstLastKeys.toArray(new StoreKey[0]);
        return new StripedIndexImpl<V>(stripesArr, firstLastKeysArr, indexLoader);
    }
}

