/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.CommitWrappedException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.exceptions.UnknownOperationResultException;
import org.projectnessie.versioned.storage.common.persist.Persist;

public class CommitRetry {
    private static final String OTEL_SLEEP_EVENT_NAME = "nessie.commit-retry.sleep";
    private static final AttributeKey<Long> OTEL_SLEEP_EVENT_TIME_KEY = AttributeKey.longKey((String)"nessie.commit-retry.sleep.duration-millis");

    private CommitRetry() {
    }

    public static <T> T commitRetry(Persist persist, CommitAttempt<T> attempt) throws CommitWrappedException, CommitConflictException, RetryTimeoutException {
        return CommitRetry.commitRetry(persist, attempt, TryLoopState.newTryLoopState(persist));
    }

    @VisibleForTesting
    static <T> T commitRetry(Persist persist, CommitAttempt<T> attempt, TryLoopState tls) throws CommitWrappedException, CommitConflictException, RetryTimeoutException {
        long t0;
        Optional<Object> retryState = Optional.empty();
        long t1 = t0 = tls.currentNanos();
        int i = 0;
        while (true) {
            block5: {
                try {
                    return attempt.attempt(persist, retryState);
                }
                catch (RetryException e) {
                    if (!tls.retry(t1)) {
                        throw new RetryTimeoutException(i, tls.currentNanos() - t0);
                    }
                    retryState = e.retryState();
                }
                catch (UnknownOperationResultException e) {
                    if (tls.retry(t1)) break block5;
                    throw new RetryTimeoutException(i, tls.currentNanos() - t0);
                }
            }
            ++i;
            t1 = tls.currentNanos();
        }
    }

    static final class TryLoopState {
        private final MonotonicClock monotonicClock;
        private final long t0;
        private final long maxTime;
        private final int maxRetries;
        private final long maxSleep;
        private long lowerBound;
        private long upperBound;
        private int retries;
        private boolean unsuccessful;

        TryLoopState(StoreConfig config, MonotonicClock monotonicClock) {
            this.maxTime = TimeUnit.MILLISECONDS.toNanos(config.commitTimeoutMillis());
            this.maxRetries = config.commitRetries();
            this.monotonicClock = monotonicClock;
            this.t0 = monotonicClock.currentNanos();
            this.lowerBound = config.retryInitialSleepMillisLower();
            this.upperBound = config.retryInitialSleepMillisUpper();
            this.maxSleep = config.retryMaxSleepMillis();
        }

        public static TryLoopState newTryLoopState(Persist persist) {
            return new TryLoopState(persist.config(), new MonotonicClock(){

                @Override
                public long currentNanos() {
                    return System.nanoTime();
                }

                @Override
                public void sleepMillis(long millis) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }

        long currentNanos() {
            return this.monotonicClock.currentNanos();
        }

        public boolean retry(long timeAttemptStarted) {
            if (this.unsuccessful) {
                return false;
            }
            ++this.retries;
            long current = this.currentNanos();
            long totalElapsed = current - this.t0;
            long attemptElapsed = timeAttemptStarted - current;
            if (this.maxTime < totalElapsed || this.maxRetries < this.retries) {
                this.unsuccessful = true;
                return false;
            }
            this.sleepAndBackoff(totalElapsed, attemptElapsed);
            return true;
        }

        private void sleepAndBackoff(long totalElapsed, long attemptElapsed) {
            long lower = this.lowerBound;
            long upper = this.upperBound;
            long sleepMillis = lower == upper ? lower : ThreadLocalRandom.current().nextLong(lower, upper);
            sleepMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(this.maxTime - totalElapsed), sleepMillis);
            sleepMillis = Math.max(1L, sleepMillis - TimeUnit.NANOSECONDS.toMillis(attemptElapsed));
            Span.current().addEvent(CommitRetry.OTEL_SLEEP_EVENT_NAME, Attributes.of(OTEL_SLEEP_EVENT_TIME_KEY, (Object)sleepMillis));
            this.monotonicClock.sleepMillis(sleepMillis);
            long max = this.maxSleep;
            if ((upper *= 2L) <= max) {
                this.lowerBound *= 2L;
                this.upperBound = upper;
            } else {
                this.upperBound = max;
            }
        }

        static interface MonotonicClock {
            public long currentNanos();

            public void sleepMillis(long var1);
        }
    }

    @FunctionalInterface
    public static interface CommitAttempt<T> {
        public T attempt(@Nonnull Persist var1, @Nonnull Optional<?> var2) throws CommitWrappedException, CommitConflictException, RetryException;
    }

    public static final class RetryException
    extends Exception {
        private final Optional<?> retryState;

        public RetryException() {
            this(Optional.empty());
        }

        public RetryException(@Nonnull Optional<?> retryState) {
            this.retryState = retryState;
        }

        public Optional<?> retryState() {
            return this.retryState;
        }
    }
}

