/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.UUID;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableAdd;
import org.projectnessie.versioned.storage.common.logic.ImmutableCreateCommit;
import org.projectnessie.versioned.storage.common.logic.ImmutableRemove;
import org.projectnessie.versioned.storage.common.logic.ImmutableUnchanged;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public interface CreateCommit {
    public ObjId parentCommitId();

    public List<ObjId> secondaryParents();

    public CommitHeaders headers();

    public String message();

    public List<Add> adds();

    public List<Unchanged> unchanged();

    public List<Remove> removes();

    @Value.Default
    default public CommitType commitType() {
        return CommitType.NORMAL;
    }

    public static Builder newCommitBuilder() {
        return ImmutableCreateCommit.builder();
    }

    @Value.Immutable
    public static interface Remove {
        @Value.Parameter(order=1)
        public StoreKey key();

        @Value.Parameter(order=2)
        public int payload();

        @Value.Parameter(order=3)
        public ObjId expectedValue();

        @Nullable
        @Value.Parameter(order=4)
        public UUID contentId();

        public static Remove commitRemove(@Nonnull StoreKey key, int payload, @Nonnull ObjId expectedValue, @Nullable UUID contentId) {
            Preconditions.checkArgument((payload >= 0 && payload <= 127 ? 1 : 0) != 0);
            return ImmutableRemove.of(key, payload, expectedValue, contentId);
        }
    }

    @Value.Immutable
    public static interface Unchanged {
        @Value.Parameter(order=1)
        public StoreKey key();

        @Value.Parameter(order=2)
        public int payload();

        @Nullable
        @Value.Parameter(order=3)
        public ObjId expectedValue();

        @Nullable
        @Value.Parameter(order=4)
        public UUID contentId();

        public static Unchanged commitUnchanged(@Nonnull StoreKey key, int payload, @Nullable ObjId expectedValue, @Nullable UUID contentId) {
            Preconditions.checkArgument((payload >= 0 && payload <= 127 ? 1 : 0) != 0);
            return ImmutableUnchanged.of(key, payload, expectedValue, contentId);
        }
    }

    @Value.Immutable
    public static interface Add {
        @Value.Parameter(order=1)
        public StoreKey key();

        @Value.Parameter(order=2)
        public int payload();

        @Value.Parameter(order=3)
        public ObjId value();

        @Nullable
        @Value.Parameter(order=4)
        public ObjId expectedValue();

        @Nullable
        @Value.Parameter(order=5)
        public UUID contentId();

        public static Add commitAdd(@Nonnull StoreKey key, int payload, @Nonnull ObjId value, @Nullable ObjId expectedValue, @Nullable UUID contentId) {
            Preconditions.checkArgument((payload >= 0 && payload <= 127 ? 1 : 0) != 0);
            return ImmutableAdd.of(key, payload, value, expectedValue, contentId);
        }
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder parentCommitId(ObjId var1);

        @CanIgnoreReturnValue
        public Builder addSecondaryParents(ObjId var1);

        @CanIgnoreReturnValue
        public Builder headers(CommitHeaders var1);

        @CanIgnoreReturnValue
        public Builder message(String var1);

        @CanIgnoreReturnValue
        public Builder addAdds(Add var1);

        @CanIgnoreReturnValue
        public Builder addUnchanged(Unchanged var1);

        @CanIgnoreReturnValue
        public Builder addRemoves(Remove var1);

        public Builder commitType(CommitType var1);

        public CreateCommit build();
    }
}

