/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import java.util.Set;
import org.agrona.collections.Object2IntHashMap;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.versioned.storage.common.logic.HeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

public class IdentifyHeadsAndForkPoints {
    private final Object2IntHashMap<ObjId> commits;
    private final Set<ObjId> heads;
    private final Set<ObjId> forkPoints;
    private final long scanStartedAtInMicros;
    private static final int MASK_COMMIT_SEEN = 1;
    private static final int MASK_PARENT_SEEN = 2;

    private static <T> Set<T> newOpenAddressingHashSet() {
        return new ObjectHashSet(8, 0.65f, false);
    }

    public IdentifyHeadsAndForkPoints(int expectedCommitCount, long scanStartedAtInMicros) {
        this.commits = new Object2IntHashMap(expectedCommitCount * 2, 0.65f, 0, true);
        this.heads = IdentifyHeadsAndForkPoints.newOpenAddressingHashSet();
        this.forkPoints = IdentifyHeadsAndForkPoints.newOpenAddressingHashSet();
        this.scanStartedAtInMicros = scanStartedAtInMicros;
    }

    public boolean handleCommit(CommitObj entry) {
        return this.handleCommit(entry.id(), entry.directParent());
    }

    public boolean isCommitNew(ObjId commitId) {
        int cv = this.commits.getValue((Object)commitId);
        return (cv & 1) == 0;
    }

    public boolean handleCommit(ObjId commitId, ObjId parent) {
        boolean parentNew;
        boolean commitNotSeenAsParent;
        boolean commitNew;
        int cv = this.commits.getValue((Object)commitId);
        boolean bl = commitNew = (cv & 1) == 0;
        if (commitNew) {
            this.commits.put((Object)commitId, cv | 1);
        }
        boolean bl2 = commitNotSeenAsParent = (cv & 2) == 0;
        if (commitNotSeenAsParent) {
            this.heads.add(commitId);
        }
        if (!commitNew) {
            return false;
        }
        if (ObjId.EMPTY_OBJ_ID.equals(parent)) {
            return true;
        }
        int pv = this.commits.getValue((Object)parent);
        boolean bl3 = parentNew = (pv & 2) == 0;
        if (!parentNew) {
            this.forkPoints.add(parent);
        } else {
            this.commits.put((Object)parent, pv | 2);
            this.heads.remove(parent);
        }
        return true;
    }

    public HeadsAndForkPoints finish() {
        return HeadsAndForkPoints.headsAndForkPoints(this.heads, this.forkPoints, this.scanStartedAtInMicros);
    }
}

