/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateCommit.Add", generator="Immutables")
@Immutable
public final class ImmutableAdd
implements CreateCommit.Add {
    private final StoreKey key;
    private final int payload;
    private final ObjId value;
    @jakarta.annotation.Nullable
    private final ObjId expectedValue;
    @jakarta.annotation.Nullable
    private final UUID contentId;

    private ImmutableAdd(StoreKey key, int payload, ObjId value, @jakarta.annotation.Nullable ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        this.key = Objects.requireNonNull(key, "key");
        this.payload = payload;
        this.value = Objects.requireNonNull(value, "value");
        this.expectedValue = expectedValue;
        this.contentId = contentId;
    }

    private ImmutableAdd(ImmutableAdd original, StoreKey key, int payload, ObjId value, @jakarta.annotation.Nullable ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        this.key = key;
        this.payload = payload;
        this.value = value;
        this.expectedValue = expectedValue;
        this.contentId = contentId;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    public int payload() {
        return this.payload;
    }

    @Override
    public ObjId value() {
        return this.value;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId expectedValue() {
        return this.expectedValue;
    }

    @Override
    @jakarta.annotation.Nullable
    public UUID contentId() {
        return this.contentId;
    }

    public final ImmutableAdd withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableAdd(this, newValue, this.payload, this.value, this.expectedValue, this.contentId);
    }

    public final ImmutableAdd withPayload(int value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableAdd(this, this.key, value, this.value, this.expectedValue, this.contentId);
    }

    public final ImmutableAdd withValue(ObjId value) {
        if (this.value == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "value");
        return new ImmutableAdd(this, this.key, this.payload, newValue, this.expectedValue, this.contentId);
    }

    public final ImmutableAdd withExpectedValue(@jakarta.annotation.Nullable ObjId value) {
        if (this.expectedValue == value) {
            return this;
        }
        return new ImmutableAdd(this, this.key, this.payload, this.value, value, this.contentId);
    }

    public final ImmutableAdd withContentId(@jakarta.annotation.Nullable UUID value) {
        if (this.contentId == value) {
            return this;
        }
        return new ImmutableAdd(this, this.key, this.payload, this.value, this.expectedValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdd && this.equalTo(0, (ImmutableAdd)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdd another) {
        return this.key.equals(another.key) && this.payload == another.payload && this.value.equals(another.value) && Objects.equals(this.expectedValue, another.expectedValue) && Objects.equals(this.contentId, another.contentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.payload;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.expectedValue);
        h += (h << 5) + Objects.hashCode(this.contentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Add").omitNullValues().add("key", (Object)this.key).add("payload", this.payload).add("value", (Object)this.value).add("expectedValue", (Object)this.expectedValue).add("contentId", (Object)this.contentId).toString();
    }

    public static ImmutableAdd of(StoreKey key, int payload, ObjId value, @jakarta.annotation.Nullable ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        return new ImmutableAdd(key, payload, value, expectedValue, contentId);
    }

    public static ImmutableAdd copyOf(CreateCommit.Add instance) {
        if (instance instanceof ImmutableAdd) {
            return (ImmutableAdd)instance;
        }
        return ImmutableAdd.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateCommit.Add", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private StoreKey key;
        private int payload;
        @Nullable
        private ObjId value;
        @Nullable
        private ObjId expectedValue;
        @Nullable
        private UUID contentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateCommit.Add instance) {
            UUID contentIdValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.payload(instance.payload());
            this.value(instance.value());
            ObjId expectedValueValue = instance.expectedValue();
            if (expectedValueValue != null) {
                this.expectedValue(expectedValueValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(int payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ObjId value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedValue(@jakarta.annotation.Nullable ObjId expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@jakarta.annotation.Nullable UUID contentId) {
            this.contentId = contentId;
            return this;
        }

        public ImmutableAdd build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAdd(null, this.key, this.payload, this.value, this.expectedValue, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build Add, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

