/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ReferencesQuery", generator="Immutables")
@Immutable
public final class ImmutableReferencesQuery
implements ReferencesQuery {
    @Nullable
    private final PagingToken pagingToken;
    @Nullable
    private final String referencePrefix;
    private final boolean prefetch;

    private ImmutableReferencesQuery(Optional<? extends PagingToken> pagingToken, Optional<String> referencePrefix, boolean prefetch) {
        this.pagingToken = pagingToken.orElse(null);
        this.referencePrefix = referencePrefix.orElse(null);
        this.prefetch = prefetch;
    }

    private ImmutableReferencesQuery(ImmutableReferencesQuery original, @Nullable PagingToken pagingToken, @Nullable String referencePrefix, boolean prefetch) {
        this.pagingToken = pagingToken;
        this.referencePrefix = referencePrefix;
        this.prefetch = prefetch;
    }

    @Override
    public Optional<PagingToken> pagingToken() {
        return Optional.ofNullable(this.pagingToken);
    }

    @Override
    public Optional<String> referencePrefix() {
        return Optional.ofNullable(this.referencePrefix);
    }

    @Override
    public boolean prefetch() {
        return this.prefetch;
    }

    public final ImmutableReferencesQuery withPagingToken(PagingToken value) {
        PagingToken newValue = Objects.requireNonNull(value, "pagingToken");
        if (this.pagingToken == newValue) {
            return this;
        }
        return new ImmutableReferencesQuery(this, newValue, this.referencePrefix, this.prefetch);
    }

    public final ImmutableReferencesQuery withPagingToken(Optional<? extends PagingToken> optional) {
        PagingToken value = optional.orElse(null);
        if (this.pagingToken == value) {
            return this;
        }
        return new ImmutableReferencesQuery(this, value, this.referencePrefix, this.prefetch);
    }

    public final ImmutableReferencesQuery withReferencePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "referencePrefix");
        if (Objects.equals(this.referencePrefix, newValue)) {
            return this;
        }
        return new ImmutableReferencesQuery(this, this.pagingToken, newValue, this.prefetch);
    }

    public final ImmutableReferencesQuery withReferencePrefix(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.referencePrefix, value)) {
            return this;
        }
        return new ImmutableReferencesQuery(this, this.pagingToken, value, this.prefetch);
    }

    public final ImmutableReferencesQuery withPrefetch(boolean value) {
        if (this.prefetch == value) {
            return this;
        }
        return new ImmutableReferencesQuery(this, this.pagingToken, this.referencePrefix, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReferencesQuery && this.equalTo(0, (ImmutableReferencesQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableReferencesQuery another) {
        return Objects.equals(this.pagingToken, another.pagingToken) && Objects.equals(this.referencePrefix, another.referencePrefix) && this.prefetch == another.prefetch;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagingToken);
        h += (h << 5) + Objects.hashCode(this.referencePrefix);
        h += (h << 5) + Booleans.hashCode((boolean)this.prefetch);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ReferencesQuery").omitNullValues().add("pagingToken", (Object)this.pagingToken).add("referencePrefix", (Object)this.referencePrefix).add("prefetch", this.prefetch).toString();
    }

    public static ImmutableReferencesQuery of(Optional<? extends PagingToken> pagingToken, Optional<String> referencePrefix, boolean prefetch) {
        return new ImmutableReferencesQuery(pagingToken, referencePrefix, prefetch);
    }

    public static ImmutableReferencesQuery copyOf(ReferencesQuery instance) {
        if (instance instanceof ImmutableReferencesQuery) {
            return (ImmutableReferencesQuery)instance;
        }
        return ImmutableReferencesQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ReferencesQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREFETCH = 1L;
        private long initBits = 1L;
        @Nullable
        private PagingToken pagingToken;
        @Nullable
        private String referencePrefix;
        private boolean prefetch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ReferencesQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageableQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PageableQuery instance;
            long bits = 0L;
            if (object instanceof ReferencesQuery) {
                instance = (ReferencesQuery)object;
                Optional<String> referencePrefixOptional = instance.referencePrefix();
                if (referencePrefixOptional.isPresent()) {
                    this.referencePrefix(referencePrefixOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
                this.prefetch(instance.prefetch());
            }
            if (object instanceof PageableQuery) {
                instance = (PageableQuery)object;
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(PagingToken pagingToken) {
            this.pagingToken = Objects.requireNonNull(pagingToken, "pagingToken");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(Optional<? extends PagingToken> pagingToken) {
            this.pagingToken = pagingToken.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referencePrefix(String referencePrefix) {
            this.referencePrefix = Objects.requireNonNull(referencePrefix, "referencePrefix");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referencePrefix(Optional<String> referencePrefix) {
            this.referencePrefix = referencePrefix.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefetch(boolean prefetch) {
            this.prefetch = prefetch;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableReferencesQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReferencesQuery(null, this.pagingToken, this.referencePrefix, this.prefetch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefetch");
            }
            return "Cannot build ReferencesQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

