/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.logic.SuppliedCommitIndex;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;

public interface IndexesLogic {
    @Nonnull
    public Supplier<SuppliedCommitIndex> createIndexSupplier(@Nonnull Supplier<ObjId> var1);

    @Nonnull
    public StoreIndex<CommitOp> buildCompleteIndex(@Nonnull CommitObj var1, Optional<StoreIndex<CommitOp>> var2);

    @Nonnull
    default public StoreIndex<CommitOp> buildCompleteIndexOrEmpty(@Nullable CommitObj commit) {
        return commit != null ? this.buildCompleteIndex(commit, Optional.empty()) : StoreIndexes.emptyImmutableIndex(CommitOp.COMMIT_OP_SERIALIZER);
    }

    @Nullable
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@Nonnull CommitObj var1);

    @Nonnull
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@Nonnull ObjId var1, @Nonnull ObjId var2);

    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexForUpdate(@Nonnull CommitObj var1, Optional<StoreIndex<CommitOp>> var2);

    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexFromCommit(@Nonnull CommitObj var1);

    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(@Nonnull CommitObj var1);

    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(@Nonnull StoreIndex<CommitOp> var1);

    @Nonnull
    public ObjId persistStripedIndex(@Nonnull StoreIndex<CommitOp> var1) throws ObjTooLargeException;

    @Nonnull
    public List<IndexStripe> persistIndexStripesFromIndex(@Nonnull StoreIndex<CommitOp> var1) throws ObjTooLargeException;

    public void completeIndexesInCommitChain(@Nonnull ObjId var1, Runnable var2) throws ObjNotFoundException;
}

