/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.CommitWrappedException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.CommitRetry;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.ImmutableRepositoryDescription;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.logic.StringLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.util.Ser;

final class RepositoryLogicImpl
implements RepositoryLogic {
    static final String REFS_HEADS = "refs/heads/";
    private final Persist persist;

    RepositoryLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    public void initialize(@Nonnull String defaultBranchName) {
        this.initialize(defaultBranchName, true, b -> {});
    }

    @Override
    public void initialize(@Nonnull String defaultBranchName, boolean createDefaultBranch, Consumer<RepositoryDescription.Builder> repositoryDescription) {
        this.initializeInternalRef(InternalRef.REF_REFS, b -> {});
        if (createDefaultBranch) {
            try {
                Logics.referenceLogic(this.persist).createReference(REFS_HEADS + defaultBranchName, ObjId.EMPTY_OBJ_ID, null);
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
            }
            catch (RetryTimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        this.initializeInternalRef(InternalRef.REF_REPO, b -> this.addRepositoryDescription((CreateCommit.Builder)b, repositoryDescription, defaultBranchName));
    }

    @Override
    public boolean repositoryExists() {
        try {
            Reference ref = this.persist.fetchReferenceForUpdate(InternalRef.REF_REPO.name());
            if (ref == null) {
                return false;
            }
            CommitObj repoDescCommit = Logics.commitLogic(this.persist).fetchCommit(ref.pointer());
            return repoDescCommit != null;
        }
        catch (ObjNotFoundException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public RepositoryDescription fetchRepositoryDescription() {
        try {
            Reference ref = this.persist.fetchReference(InternalRef.REF_REPO.name());
            if (ref == null) {
                return null;
            }
            CommitObj repoDescCommit = Logics.commitLogic(this.persist).fetchCommit(ref.pointer());
            if (repoDescCommit == null) {
                return null;
            }
            StoreIndex<CommitOp> index = Logics.indexesLogic(this.persist).buildCompleteIndex(repoDescCommit, Optional.empty());
            StoreIndexElement<CommitOp> el = index.get(InternalRef.KEY_REPO_DESCRIPTION);
            if (el == null) {
                return null;
            }
            CommitOp op = el.content();
            if (!op.action().exists()) {
                return null;
            }
            StringLogic.StringValue value = Logics.stringLogic(this.persist).fetchString(Objects.requireNonNull(op.value(), "Commit operation for repository description has no value"));
            return RepositoryLogicImpl.deserialize(value);
        }
        catch (ObjNotFoundException e) {
            return null;
        }
    }

    private static RepositoryDescription deserialize(StringLogic.StringValue value) {
        try {
            return (RepositoryDescription)Ser.SHARED_OBJECT_MAPPER.readValue(value.completeValue(), RepositoryDescription.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] serialize(RepositoryDescription repositoryDescription) {
        try {
            return Ser.SHARED_OBJECT_MAPPER.writeValueAsBytes((Object)repositoryDescription);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addRepositoryDescription(CreateCommit.Builder b, Consumer<RepositoryDescription.Builder> repositoryDescription, String defaultBranchName) {
        try {
            Instant now = Instant.now(this.persist.config().clock());
            RepositoryDescription.Builder repoDesc = RepositoryDescription.builder().oldestPossibleCommitTime(now).repositoryCreatedTime(now).defaultBranchName(defaultBranchName);
            repositoryDescription.accept(repoDesc);
            StringObj string = Logics.stringLogic(this.persist).updateString(null, "application/json", Ser.SHARED_OBJECT_MAPPER.writeValueAsBytes((Object)repoDesc.build()));
            this.persist.storeObj(string);
            b.addAdds(CreateCommit.Add.commitAdd(InternalRef.KEY_REPO_DESCRIPTION, 0, Objects.requireNonNull(string.id()), null, null));
        }
        catch (IOException | ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RepositoryDescription updateRepositoryDescription(RepositoryDescription newDescription) throws RetryTimeoutException {
        RepositoryDescription existingDescription = Objects.requireNonNull(this.fetchRepositoryDescription());
        ImmutableRepositoryDescription sanitizedDescription = ImmutableRepositoryDescription.builder().from(newDescription).oldestPossibleCommitTime(existingDescription.oldestPossibleCommitTime()).repositoryCreatedTime(existingDescription.repositoryCreatedTime()).build();
        byte[] serialized = RepositoryLogicImpl.serialize(sanitizedDescription);
        try {
            StringLogic.StringValue existing = CommitRetry.commitRetry(this.persist, (p, retryState) -> {
                try {
                    Reference reference = Objects.requireNonNull(this.persist.fetchReferenceForUpdate(InternalRef.REF_REPO.name()));
                    return Logics.stringLogic(this.persist).updateStringOnRef(reference, InternalRef.KEY_REPO_DESCRIPTION, b -> b.message("Update repository description").commitType(CommitType.INTERNAL), "application/json", serialized);
                }
                catch (CommitConflictException | RefConditionFailedException e) {
                    throw new CommitRetry.RetryException();
                }
                catch (ObjNotFoundException | RefNotFoundException e) {
                    throw new CommitWrappedException(e);
                }
            });
            return existing != null ? RepositoryLogicImpl.deserialize(existing) : null;
        }
        catch (CommitConflictException e) {
            throw new RuntimeException("An unexpected internal error happened while committing a repository description update");
        }
        catch (CommitWrappedException e) {
            throw new RuntimeException("An unexpected internal error happened while committing a repository description update", e.getCause());
        }
    }

    private void initializeInternalRef(InternalRef internalRef, Consumer<CreateCommit.Builder> commitEnhancer) {
        Reference reference = this.persist.fetchReferenceForUpdate(internalRef.name());
        if (reference == null) {
            CommitObj commit;
            CreateCommit.Builder c = CreateCommit.newCommitBuilder().parentCommitId(ObjId.EMPTY_OBJ_ID).headers(CommitHeaders.newCommitHeaders().add("repo.id", this.persist.config().repositoryId()).add("timestamp", OffsetDateTime.now()).build()).message("Initialize reference " + internalRef.name()).commitType(CommitType.INTERNAL);
            commitEnhancer.accept(c);
            CommitLogic commitLogic = Logics.commitLogic(this.persist);
            try {
                commit = commitLogic.doCommit(c.build(), Collections.emptyList());
            }
            catch (CommitConflictException | ObjNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                this.persist.addReference(Reference.reference(internalRef.name(), commit.id(), false, this.persist.config().currentTimeMicros(), null));
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
                // empty catch block
            }
        }
    }
}

