/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Set;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeadersImpl;
import org.projectnessie.versioned.storage.common.persist.Hashable;
import org.projectnessie.versioned.storage.common.persist.ObjIdHasher;

public interface CommitHeaders
extends Hashable {
    public static final CommitHeaders EMPTY_COMMIT_HEADERS = CommitHeaders.newCommitHeaders().build();

    public static String capitalizeName(String name) {
        StringBuilder sb = new StringBuilder();
        boolean word = true;
        int l = name.length();
        for (int i = 0; i < l; ++i) {
            char c = name.charAt(i);
            boolean letter = Character.isLetter(c);
            if (word) {
                if (letter) {
                    word = false;
                    c = Character.toUpperCase(c);
                }
            } else if (!letter) {
                word = true;
            } else {
                c = Character.toLowerCase(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public String getFirst(String var1);

    public List<String> getAll(String var1);

    public Set<String> keySet();

    default public Builder toBuilder() {
        return CommitHeaders.newCommitHeaders().from(this);
    }

    public static Builder newCommitHeaders() {
        return CommitHeadersImpl.builder();
    }

    @Override
    default public void hash(ObjIdHasher hasher) {
        for (String header : this.keySet()) {
            hasher.hash(header);
            List<String> values = this.getAll(header);
            for (String value : values) {
                hasher.hash(value);
            }
        }
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder add(String var1, String var2);

        @CanIgnoreReturnValue
        public Builder from(CommitHeaders var1);

        @CanIgnoreReturnValue
        default public Builder add(String name, OffsetDateTime offsetDateTime) {
            return this.add(name, offsetDateTime.toString());
        }

        public CommitHeaders build();
    }
}

