/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableCommitOp;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.util.Ser;

@Value.Immutable
public interface CommitOp {
    public static final ElementSerializer<CommitOp> COMMIT_OP_SERIALIZER = new CommitEntrySerializer();

    @Value.Parameter(order=1)
    public Action action();

    @Value.Parameter(order=2)
    public int payload();

    @Nullable
    @Value.Parameter(order=3)
    public ObjId value();

    @Nullable
    @Value.Parameter(order=4)
    public UUID contentId();

    public static CommitOp commitOp(@Nonnull Action action, int payload, @Nullable ObjId value) {
        return CommitOp.commitOp(action, payload, value, null);
    }

    public static CommitOp commitOp(@Nonnull Action action, int payload, @Nullable ObjId value, @Nullable UUID contentId) {
        Preconditions.checkArgument((payload >= 0 && payload <= 127 ? 1 : 0) != 0);
        Preconditions.checkArgument((value == null || value.size() > 0 ? 1 : 0) != 0);
        return ImmutableCommitOp.of(action, payload, value, contentId);
    }

    public static UUID contentIdMaybe(String contentId) {
        try {
            return UUID.fromString(contentId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum Action {
        NONE('N', true, false),
        ADD('A', true, true),
        REMOVE('R', false, true),
        INCREMENTAL_ADD('a', true, false),
        INCREMENTAL_REMOVE('r', false, false);

        private final char value;
        private final boolean exists;
        private final boolean currentCommit;

        public static Action fromValue(char value) {
            switch (value) {
                case 'N': {
                    return NONE;
                }
                case 'A': {
                    return ADD;
                }
                case 'R': {
                    return REMOVE;
                }
                case 'a': {
                    return INCREMENTAL_ADD;
                }
                case 'r': {
                    return INCREMENTAL_REMOVE;
                }
            }
            throw new IllegalArgumentException("Illegal value '" + value + "' for Operation");
        }

        private Action(char value, boolean exists, boolean currentCommit) {
            this.value = value;
            this.exists = exists;
            this.currentCommit = currentCommit;
        }

        public char value() {
            return this.value;
        }

        public boolean exists() {
            return this.exists;
        }

        public boolean currentCommit() {
            return this.currentCommit;
        }
    }

    public static final class CommitEntrySerializer
    implements ElementSerializer<CommitOp> {
        @Override
        public int serializedSize(CommitOp value) {
            ObjId v = value.value();
            if (v == null) {
                v = ObjId.zeroLengthObjId();
            }
            return 2 + v.serializedSize() + 16;
        }

        @Override
        public ByteBuffer serialize(CommitOp value, ByteBuffer target) {
            target.put((byte)value.action().value());
            Ser.putVarInt(target, value.payload());
            ObjId v = value.value();
            if (v == null) {
                v = ObjId.zeroLengthObjId();
            }
            v.serializeTo(target);
            UUID contentId = value.contentId();
            if (contentId != null) {
                target.putLong(contentId.getMostSignificantBits()).putLong(contentId.getLeastSignificantBits());
            } else {
                target.putLong(0L).putLong(0L);
            }
            return target;
        }

        @Override
        public CommitOp deserialize(ByteBuffer buffer) {
            Action operation = Action.fromValue((char)buffer.get());
            int payload = Ser.readVarInt(buffer);
            ObjId id = ObjId.deserializeObjId(buffer);
            if (id.size() == 0) {
                id = null;
            }
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            UUID contentId = msb != 0L || lsb != 0L ? new UUID(msb, lsb) : null;
            return CommitOp.commitOp(operation, payload, id, contentId);
        }

        @Override
        public void skip(ByteBuffer buffer) {
            buffer.get();
            Ser.skipVarInt(buffer);
            ObjId.skipObjId(buffer);
            buffer.position(buffer.position() + 16);
        }
    }
}

