/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import java.util.function.LongSupplier;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjType;

public abstract class CustomObjType<T extends Obj>
implements ObjType {
    private final String name;
    private final String shortName;
    private final Class<T> targetClass;

    private CustomObjType(String name, String shortName, Class<T> targetClass) {
        this.name = name;
        this.shortName = shortName;
        this.targetClass = targetClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    public Class<T> targetClass() {
        return this.targetClass;
    }

    public static <T extends Obj> ObjType customObjType(String name, String shortName, Class<T> targetClass) {
        return new CustomObjType<T>(name, shortName, (Class)targetClass){};
    }

    public static <T extends Obj> ObjType uncachedObjType(String name, String shortName, Class<T> targetClass) {
        return new CustomObjType<T>(name, shortName, (Class)targetClass){

            @Override
            public long cachedObjectExpiresAtMicros(Obj obj, LongSupplier clock) {
                return 0L;
            }
        };
    }

    public static <T extends Obj> ObjType dynamicCaching(String name, String shortName, Class<T> targetClass, final CacheExpireCalculation<T> cacheExpireCalculation, final CacheNegativeCalculation cacheNegativeCalculation) {
        return new CustomObjType<T>(name, shortName, targetClass){

            @Override
            public long cachedObjectExpiresAtMicros(Obj obj, LongSupplier clock) {
                Obj casted = obj;
                return cacheExpireCalculation.calculateExpiresAt(casted, clock.getAsLong());
            }

            @Override
            public long negativeCacheExpiresAtMicros(LongSupplier clock) {
                return cacheNegativeCalculation.negativeCacheExpiresAtMicros(clock.getAsLong());
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomObjType that = (CustomObjType)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @FunctionalInterface
    public static interface CacheExpireCalculation<T extends Obj> {
        public long calculateExpiresAt(T var1, long var2);
    }

    @FunctionalInterface
    public static interface CacheNegativeCalculation {
        public long negativeCacheExpiresAtMicros(long var1);
    }
}

