/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.projectnessie.versioned.storage.common.objtypes.CustomObjType;
import org.projectnessie.versioned.storage.common.objtypes.GenericObj;
import org.projectnessie.versioned.storage.common.persist.ObjType;

public final class GenericObjTypeMapper {
    private final Map<String, ObjType> genericTypes = new ConcurrentHashMap<String, ObjType>();

    @Nonnull
    public ObjType mapGenericObjType(String nameOrShortName) {
        return this.genericTypes.computeIfAbsent(nameOrShortName, GenericObjTypeMapper::newGenericObjType);
    }

    @VisibleForTesting
    public static ObjType newGenericObjType(String name) {
        return CustomObjType.uncachedObjType(name, name, GenericObj.class);
    }
}

