/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StringObj", generator="Immutables")
@Immutable
public final class ImmutableStringObj
implements StringObj {
    @Nullable
    private final ObjId id;
    private final long referenced;
    private final String contentType;
    private final Compression compression;
    @Nullable
    private final String filename;
    private final ImmutableList<ObjId> predecessors;
    private final ByteString text;

    private ImmutableStringObj(@Nullable ObjId id, long referenced, String contentType, Compression compression, @Nullable String filename, Iterable<? extends ObjId> predecessors, ByteString text) {
        this.id = id;
        this.referenced = referenced;
        this.contentType = Objects.requireNonNull(contentType, "contentType");
        this.compression = Objects.requireNonNull(compression, "compression");
        this.filename = filename;
        this.predecessors = ImmutableList.copyOf(predecessors);
        this.text = Objects.requireNonNull(text, "text");
    }

    private ImmutableStringObj(ImmutableStringObj original, @Nullable ObjId id, long referenced, String contentType, Compression compression, @Nullable String filename, ImmutableList<ObjId> predecessors, ByteString text) {
        this.id = id;
        this.referenced = referenced;
        this.contentType = contentType;
        this.compression = compression;
        this.filename = filename;
        this.predecessors = predecessors;
        this.text = text;
    }

    @Override
    @Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    @Override
    public Compression compression() {
        return this.compression;
    }

    @Override
    @Nullable
    public String filename() {
        return this.filename;
    }

    public ImmutableList<ObjId> predecessors() {
        return this.predecessors;
    }

    @Override
    public ByteString text() {
        return this.text;
    }

    public final ImmutableStringObj withId(@Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableStringObj(this, value, this.referenced, this.contentType, this.compression, this.filename, this.predecessors, this.text);
    }

    @Override
    public final ImmutableStringObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableStringObj(this, this.id, value, this.contentType, this.compression, this.filename, this.predecessors, this.text);
    }

    public final ImmutableStringObj withContentType(String value) {
        String newValue = Objects.requireNonNull(value, "contentType");
        if (this.contentType.equals(newValue)) {
            return this;
        }
        return new ImmutableStringObj(this, this.id, this.referenced, newValue, this.compression, this.filename, this.predecessors, this.text);
    }

    public final ImmutableStringObj withCompression(Compression value) {
        Compression newValue = Objects.requireNonNull(value, "compression");
        if (this.compression == newValue) {
            return this;
        }
        return new ImmutableStringObj(this, this.id, this.referenced, this.contentType, newValue, this.filename, this.predecessors, this.text);
    }

    public final ImmutableStringObj withFilename(@Nullable String value) {
        if (Objects.equals(this.filename, value)) {
            return this;
        }
        return new ImmutableStringObj(this, this.id, this.referenced, this.contentType, this.compression, value, this.predecessors, this.text);
    }

    public final ImmutableStringObj withPredecessors(ObjId ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableStringObj(this, this.id, this.referenced, this.contentType, this.compression, this.filename, (ImmutableList<ObjId>)newValue, this.text);
    }

    public final ImmutableStringObj withPredecessors(Iterable<? extends ObjId> elements) {
        if (this.predecessors == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableStringObj(this, this.id, this.referenced, this.contentType, this.compression, this.filename, (ImmutableList<ObjId>)newValue, this.text);
    }

    public final ImmutableStringObj withText(ByteString value) {
        if (this.text == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "text");
        return new ImmutableStringObj(this, this.id, this.referenced, this.contentType, this.compression, this.filename, this.predecessors, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStringObj && this.equalTo(0, (ImmutableStringObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableStringObj another) {
        return Objects.equals(this.id, another.id) && this.contentType.equals(another.contentType) && this.compression.equals((Object)another.compression) && Objects.equals(this.filename, another.filename) && this.predecessors.equals(another.predecessors) && this.text.equals((Object)another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.contentType.hashCode();
        h += (h << 5) + this.compression.hashCode();
        h += (h << 5) + Objects.hashCode(this.filename);
        h += (h << 5) + this.predecessors.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StringObj").omitNullValues().add("id", (Object)this.id).add("contentType", (Object)this.contentType).add("compression", (Object)this.compression).add("filename", (Object)this.filename).add("predecessors", this.predecessors).add("text", (Object)this.text).toString();
    }

    public static ImmutableStringObj of(@Nullable ObjId id, long referenced, String contentType, Compression compression, @Nullable String filename, List<ObjId> predecessors, ByteString text) {
        return ImmutableStringObj.of(id, referenced, contentType, compression, filename, predecessors, text);
    }

    public static ImmutableStringObj of(@Nullable ObjId id, long referenced, String contentType, Compression compression, @Nullable String filename, Iterable<? extends ObjId> predecessors, ByteString text) {
        return new ImmutableStringObj(id, referenced, contentType, compression, filename, predecessors, text);
    }

    public static ImmutableStringObj copyOf(StringObj instance) {
        if (instance instanceof ImmutableStringObj) {
            return (ImmutableStringObj)instance;
        }
        return ImmutableStringObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StringObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_REFERENCED = 1L;
        private static final long INIT_BIT_CONTENT_TYPE = 2L;
        private static final long INIT_BIT_COMPRESSION = 4L;
        private static final long INIT_BIT_TEXT = 8L;
        private long initBits = 15L;
        @javax.annotation.Nullable
        private ObjId id;
        private long referenced;
        @javax.annotation.Nullable
        private String contentType;
        @javax.annotation.Nullable
        private Compression compression;
        @javax.annotation.Nullable
        private String filename;
        private ImmutableList.Builder<ObjId> predecessors = ImmutableList.builder();
        @javax.annotation.Nullable
        private ByteString text;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StringObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof StringObj) {
                instance = (StringObj)object;
                this.addAllPredecessors(instance.predecessors());
                String filenameValue = instance.filename();
                if (filenameValue != null) {
                    this.filename(filenameValue);
                }
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                this.text(instance.text());
                this.compression(instance.compression());
                this.contentType(instance.contentType());
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentType(String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder compression(Compression compression) {
            this.compression = Objects.requireNonNull(compression, "compression");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filename(@Nullable String filename) {
            this.filename = filename;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPredecessors(ObjId element) {
            this.predecessors.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPredecessors(ObjId ... elements) {
            this.predecessors.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder predecessors(Iterable<? extends ObjId> elements) {
            this.predecessors = ImmutableList.builder();
            return this.addAllPredecessors(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPredecessors(Iterable<? extends ObjId> elements) {
            this.predecessors.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder text(ByteString text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableStringObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStringObj(null, this.id, this.referenced, this.contentType, this.compression, this.filename, (ImmutableList<ObjId>)this.predecessors.build(), this.text);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("referenced");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("compression");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("text");
            }
            return "Cannot build StringObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

