/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.projectnessie.versioned.storage.common.objtypes.GenericObjTypeMapper;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.ObjTypeBundle;

public final class ObjTypes {
    @Nonnull
    public static Set<ObjType> allObjTypes() {
        return Registry.OBJ_TYPES;
    }

    @Nonnull
    public static ObjType objTypeByName(@Nonnull String name) {
        ObjType type = Registry.BY_ANY_NAME.get(name);
        if (type == null) {
            type = Registry.maybeMapped(name);
        }
        return type;
    }

    @Nonnull
    @Deprecated(forRemoval=true)
    public static ObjType forName(@Nonnull String name) {
        return ObjTypes.objTypeByName(name);
    }

    @Nonnull
    @Deprecated(forRemoval=true)
    public static ObjType forShortName(@Nonnull String shortName) {
        return ObjTypes.objTypeByName(shortName);
    }

    private static final class Registry {
        private static final Map<String, ObjType> BY_ANY_NAME;
        private static final Set<ObjType> OBJ_TYPES;
        private static final GenericObjTypeMapper OBJ_TYPE_MAPPER;

        private Registry() {
        }

        static ObjType maybeMapped(String name) {
            return OBJ_TYPE_MAPPER.mapGenericObjType(name);
        }

        static {
            TreeMap byAnyName = new TreeMap();
            TreeMap byName = new TreeMap();
            HashMap byShortName = new HashMap();
            for (ObjTypeBundle bundle : ServiceLoader.load(ObjTypeBundle.class)) {
                bundle.register(objType -> {
                    if (byName.put(objType.name(), objType) != null) {
                        throw new IllegalStateException("Duplicate object type name: " + objType.name());
                    }
                    if (byShortName.put(objType.shortName(), objType) != null) {
                        throw new IllegalStateException("Duplicate object type short name: " + objType.shortName());
                    }
                    if (byAnyName.containsKey(objType.name()) || byAnyName.containsKey(objType.shortName())) {
                        throw new IllegalStateException("Duplicate object type name/short name: " + objType.name() + "/" + objType.shortName());
                    }
                    byAnyName.put(objType.name(), objType);
                    byAnyName.put(objType.shortName(), objType);
                });
            }
            BY_ANY_NAME = Collections.unmodifiableMap(byAnyName);
            OBJ_TYPES = Set.copyOf(byName.values());
            OBJ_TYPE_MAPPER = new GenericObjTypeMapper();
        }
    }
}

