/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.exceptions;

import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.versioned.storage.common.exceptions.CommitException;
import org.projectnessie.versioned.storage.common.logic.CommitConflict;

public class CommitConflictException
extends CommitException {
    private final List<CommitConflict> conflicts;

    public CommitConflictException(List<CommitConflict> conflicts) {
        super("Commit conflict");
        this.conflicts = conflicts;
    }

    @Override
    public String getMessage() {
        return "Commit conflict: " + this.conflicts.stream().map(c -> c.conflictType().name() + ":" + c.key().toString()).collect(Collectors.joining(", "));
    }

    public List<CommitConflict> conflicts() {
        return this.conflicts;
    }
}

