/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import java.util.Arrays;
import org.projectnessie.versioned.storage.common.persist.ObjId;

final class ShallowCommit {
    static final int COMMIT_A = 1;
    static final int COMMIT_B = 2;
    static final int CANDIDATE = 4;
    static final int RESULT = 8;
    static final int BOTH_COMMITS = 3;
    static final int REACHABILITY_FLAGS = 7;
    static final int ALL_FLAGS = 15;
    private final ObjId id;
    private final ObjId[] parents;
    private final long seq;
    private int flags;

    ShallowCommit(ObjId id, ObjId[] parents, long seq) {
        this.id = id;
        this.parents = parents;
        this.seq = seq;
    }

    ObjId id() {
        return this.id;
    }

    ObjId[] parents() {
        return this.parents;
    }

    long seq() {
        return this.seq;
    }

    int flags() {
        return this.flags;
    }

    int reachabilityFlags() {
        return this.flags & 7;
    }

    boolean isCandidate() {
        return (this.flags & 4) != 0;
    }

    boolean isNotCandidate() {
        return (this.flags & 4) == 0;
    }

    boolean isAnyFlagSet(int flags) {
        return (this.flags & flags) != 0;
    }

    void setCommitA() {
        this.flags |= 1;
    }

    void setCommitB() {
        this.flags |= 2;
    }

    void clearCandidate() {
        this.flags &= 0xFFFFFFFB;
    }

    boolean clearFlagsIfAnySet(int flags) {
        int ex = this.flags;
        if ((ex & flags) != 0) {
            this.flags = ex & ~flags;
            return true;
        }
        return false;
    }

    boolean setAllFlagsIfAnyMissing(int flags) {
        int ex = this.flags;
        if ((ex & flags) != flags) {
            this.flags = ex | flags;
            return true;
        }
        return false;
    }

    boolean setCandidate() {
        int ex = this.flags;
        if ((ex & 4) == 0) {
            this.flags = ex | 4;
            return true;
        }
        return false;
    }

    boolean setResult() {
        int ex = this.flags;
        if ((ex & 8) == 0) {
            this.flags = ex | 8;
            return true;
        }
        return false;
    }

    boolean clearResult() {
        int ex = this.flags;
        if ((ex & 8) != 0) {
            this.flags = ex & 0xFFFFFFF7;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder f = new StringBuilder();
        if ((this.flags & 3) == 3) {
            f.append("BOTH_COMMITS");
        } else {
            if ((this.flags & 1) != 0) {
                f.append("COMMIT_A");
            }
            if ((this.flags & 2) != 0) {
                if (f.length() > 0) {
                    f.append(", ");
                }
                f.append("COMMIT_B");
            }
        }
        if ((this.flags & 4) != 0) {
            if (f.length() > 0) {
                f.append(", ");
            }
            f.append("CANDIDATE");
        }
        if ((this.flags & 8) != 0) {
            if (f.length() > 0) {
                f.append(", ");
            }
            f.append("RESULT");
        }
        return "ShallowCommit{id=" + String.valueOf(this.id) + ", parents=" + Arrays.toString(this.parents) + ", seq=" + this.seq + ", flags=" + String.valueOf(f) + "}";
    }
}

