/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

public enum CommitType {
    NORMAL("n"),
    INTERNAL("i");

    private static final CommitType[] ALL_COMMIT_TYPES;
    private final String shortName;

    private CommitType(String shortName) {
        this.shortName = shortName;
    }

    public static CommitType fromShortName(String shortName) {
        for (CommitType type : ALL_COMMIT_TYPES) {
            if (!type.shortName().equals(shortName)) continue;
            return type;
        }
        throw new IllegalStateException("Unknown commit short type name " + shortName);
    }

    public String shortName() {
        return this.shortName;
    }

    static {
        ALL_COMMIT_TYPES = CommitType.values();
    }
}

