/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;

final class ImmutableEmptyIndexImpl<V>
implements StoreIndex<V> {
    private final ElementSerializer<V> serializer;

    ImmutableEmptyIndexImpl(ElementSerializer<V> serializer) {
        this.serializer = serializer;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        return this;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        return StoreIndexes.newStoreIndex(this.serializer);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        throw new UnsupportedOperationException("Operation not supported for non-mutable indexes");
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return Collections.emptyList();
    }

    @Override
    public int elementCount() {
        return 0;
    }

    @Override
    public int estimatedSerializedSize() {
        return 1;
    }

    @Override
    public boolean add(@Nonnull StoreIndexElement<V> element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
    }

    @Override
    public boolean remove(@Nonnull StoreKey key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(@Nonnull StoreKey key) {
        return false;
    }

    @Override
    @Nullable
    public StoreIndexElement<V> get(@Nonnull StoreKey key) {
        return null;
    }

    @Override
    @Nullable
    public StoreKey first() {
        return null;
    }

    @Override
    @Nullable
    public StoreKey last() {
        return null;
    }

    @Override
    public List<StoreKey> asKeyList() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(@Nullable StoreKey begin, @Nullable StoreKey end, boolean prefetch) {
        return Collections.emptyIterator();
    }

    @Override
    @Nonnull
    public ByteString serialize() {
        ByteBuffer target = ByteBuffer.allocate(this.estimatedSerializedSize());
        target.put((byte)1);
        target.flip();
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)target);
    }
}

