/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.UUID;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableDiffEntry;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public interface DiffEntry {
    @Value.Parameter(order=1)
    public StoreKey key();

    @Nullable
    @Value.Parameter(order=2)
    public ObjId fromId();

    @Value.Parameter(order=3)
    public int fromPayload();

    @Nullable
    @Value.Parameter(order=4)
    public UUID fromContentId();

    @Nullable
    @Value.Parameter(order=5)
    public ObjId toId();

    @Value.Parameter(order=6)
    public int toPayload();

    @Nullable
    @Value.Parameter(order=7)
    public UUID toContentId();

    @Nonnull
    public static DiffEntry diffEntry(@Nonnull StoreKey key, @Nullable ObjId fromId, int fromPayload, @Nullable UUID fromContentId, @Nullable ObjId toId, int toPayload, @Nullable UUID toContentId) {
        Preconditions.checkArgument((fromId == null && fromPayload == 0 && fromContentId == null || fromId != null && fromPayload >= 0 && fromPayload <= 127 ? 1 : 0) != 0);
        Preconditions.checkArgument((toId == null && toPayload == 0 && toContentId == null || toId != null && toPayload >= 0 && toPayload <= 127 ? 1 : 0) != 0);
        return ImmutableDiffEntry.of(key, fromId, fromPayload, fromContentId, toId, toPayload, toContentId);
    }
}

