/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.CommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitLogQuery", generator="Immutables")
@Immutable
public final class ImmutableCommitLogQuery
implements CommitLogQuery {
    @Nullable
    private final PagingToken pagingToken;
    private final ObjId commitId;
    @Nullable
    private final ObjId endCommitId;

    private ImmutableCommitLogQuery(Optional<? extends PagingToken> pagingToken, ObjId commitId, Optional<? extends ObjId> endCommitId) {
        this.pagingToken = pagingToken.orElse(null);
        this.commitId = Objects.requireNonNull(commitId, "commitId");
        this.endCommitId = endCommitId.orElse(null);
    }

    private ImmutableCommitLogQuery(ImmutableCommitLogQuery original, @Nullable PagingToken pagingToken, ObjId commitId, @Nullable ObjId endCommitId) {
        this.pagingToken = pagingToken;
        this.commitId = commitId;
        this.endCommitId = endCommitId;
    }

    @Override
    public Optional<PagingToken> pagingToken() {
        return Optional.ofNullable(this.pagingToken);
    }

    @Override
    public ObjId commitId() {
        return this.commitId;
    }

    @Override
    public Optional<ObjId> endCommitId() {
        return Optional.ofNullable(this.endCommitId);
    }

    public final ImmutableCommitLogQuery withPagingToken(PagingToken value) {
        PagingToken newValue = Objects.requireNonNull(value, "pagingToken");
        if (this.pagingToken == newValue) {
            return this;
        }
        return new ImmutableCommitLogQuery(this, newValue, this.commitId, this.endCommitId);
    }

    public final ImmutableCommitLogQuery withPagingToken(Optional<? extends PagingToken> optional) {
        PagingToken value = optional.orElse(null);
        if (this.pagingToken == value) {
            return this;
        }
        return new ImmutableCommitLogQuery(this, value, this.commitId, this.endCommitId);
    }

    public final ImmutableCommitLogQuery withCommitId(ObjId value) {
        if (this.commitId == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "commitId");
        return new ImmutableCommitLogQuery(this, this.pagingToken, newValue, this.endCommitId);
    }

    public final ImmutableCommitLogQuery withEndCommitId(ObjId value) {
        ObjId newValue = Objects.requireNonNull(value, "endCommitId");
        if (this.endCommitId == newValue) {
            return this;
        }
        return new ImmutableCommitLogQuery(this, this.pagingToken, this.commitId, newValue);
    }

    public final ImmutableCommitLogQuery withEndCommitId(Optional<? extends ObjId> optional) {
        ObjId value = optional.orElse(null);
        if (this.endCommitId == value) {
            return this;
        }
        return new ImmutableCommitLogQuery(this, this.pagingToken, this.commitId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitLogQuery && this.equalTo(0, (ImmutableCommitLogQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitLogQuery another) {
        return Objects.equals(this.pagingToken, another.pagingToken) && this.commitId.equals(another.commitId) && Objects.equals(this.endCommitId, another.endCommitId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagingToken);
        h += (h << 5) + this.commitId.hashCode();
        h += (h << 5) + Objects.hashCode(this.endCommitId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitLogQuery").omitNullValues().add("pagingToken", (Object)this.pagingToken).add("commitId", (Object)this.commitId).add("endCommitId", (Object)this.endCommitId).toString();
    }

    public static ImmutableCommitLogQuery of(Optional<? extends PagingToken> pagingToken, ObjId commitId, Optional<? extends ObjId> endCommitId) {
        return new ImmutableCommitLogQuery(pagingToken, commitId, endCommitId);
    }

    public static ImmutableCommitLogQuery copyOf(CommitLogQuery instance) {
        if (instance instanceof ImmutableCommitLogQuery) {
            return (ImmutableCommitLogQuery)instance;
        }
        return ImmutableCommitLogQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitLogQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private PagingToken pagingToken;
        @Nullable
        private ObjId commitId;
        @Nullable
        private ObjId endCommitId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PageableQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitLogQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            PageableQuery instance;
            long bits = 0L;
            if (object instanceof PageableQuery) {
                instance = (PageableQuery)object;
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof CommitLogQuery) {
                instance = (CommitLogQuery)object;
                Optional<ObjId> endCommitIdOptional = instance.endCommitId();
                if (endCommitIdOptional.isPresent()) {
                    this.endCommitId(endCommitIdOptional);
                }
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
                this.commitId(instance.commitId());
            }
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(PagingToken pagingToken) {
            this.pagingToken = Objects.requireNonNull(pagingToken, "pagingToken");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(Optional<? extends PagingToken> pagingToken) {
            this.pagingToken = pagingToken.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitId(ObjId commitId) {
            this.commitId = Objects.requireNonNull(commitId, "commitId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endCommitId(ObjId endCommitId) {
            this.endCommitId = Objects.requireNonNull(endCommitId, "endCommitId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder endCommitId(Optional<? extends ObjId> endCommitId) {
            this.endCommitId = endCommitId.orElse(null);
            return this;
        }

        public ImmutableCommitLogQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitLogQuery(null, this.pagingToken, this.commitId, this.endCommitId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commitId");
            }
            return "Cannot build CommitLogQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

