/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.CommitOpHandler;
import org.projectnessie.versioned.storage.common.logic.ConflictHandler;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.DiffEntry;
import org.projectnessie.versioned.storage.common.logic.DiffPagedResult;
import org.projectnessie.versioned.storage.common.logic.DiffQuery;
import org.projectnessie.versioned.storage.common.logic.HeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.StoredObjResult;

public interface CommitLogic {
    @Nonnull
    public PagedResult<CommitObj, ObjId> commitLog(@Nonnull CommitLogQuery var1);

    @Nonnull
    public PagedResult<ObjId, ObjId> commitIdLog(@Nonnull CommitLogQuery var1);

    @Nonnull
    public DiffPagedResult<DiffEntry, StoreKey> diff(@Nonnull DiffQuery var1);

    @Nullable
    public CommitObj doCommit(@Nonnull CreateCommit var1, @Nonnull List<Obj> var2) throws CommitConflictException, ObjNotFoundException;

    @NotNull
    public StoredObjResult<CommitObj> storeCommit(@Nonnull CommitObj var1, @Nonnull List<Obj> var2);

    public CommitObj updateCommit(@Nonnull CommitObj var1);

    @Nonnull
    public CommitObj buildCommitObj(@Nonnull CreateCommit var1, @Nonnull ConflictHandler var2, CommitOpHandler var3, @Nonnull ValueReplacement var4, @Nonnull ValueReplacement var5) throws CommitConflictException, ObjNotFoundException;

    @Nonnull
    default public CommitObj buildCommitObj(@Nonnull CreateCommit createCommit) throws CommitConflictException, ObjNotFoundException {
        return this.buildCommitObj(createCommit, c -> ConflictHandler.ConflictResolution.CONFLICT, (k, v) -> {}, ValueReplacement.NO_VALUE_REPLACEMENT, ValueReplacement.NO_VALUE_REPLACEMENT);
    }

    @Nonnull
    public ObjId findCommonAncestor(@Nonnull ObjId var1, @Nonnull ObjId var2) throws NoSuchElementException;

    @Nonnull
    public ObjId findMergeBase(@Nonnull ObjId var1, @Nonnull ObjId var2) throws NoSuchElementException;

    @Nullable
    public CommitObj fetchCommit(@Nonnull ObjId var1) throws ObjNotFoundException;

    @Nonnull
    public CommitObj[] fetchCommits(@Nonnull ObjId var1, @Nonnull ObjId var2) throws ObjNotFoundException;

    @Nonnull
    public CreateCommit.Builder diffToCreateCommit(@Nonnull PagedResult<DiffEntry, StoreKey> var1, @Nonnull CreateCommit.Builder var2);

    @Nullable
    public CommitObj headCommit(@Nonnull Reference var1) throws ObjNotFoundException;

    public HeadsAndForkPoints identifyAllHeadsAndForkPoints(int var1, Consumer<CommitObj> var2);

    @FunctionalInterface
    public static interface ValueReplacement {
        public static final ValueReplacement NO_VALUE_REPLACEMENT = (add, key, id) -> id;

        @Nullable
        public ObjId maybeReplaceValue(boolean var1, StoreKey var2, ObjId var3);
    }
}

