/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="CreateCommit.Unchanged", generator="Immutables")
public final class ImmutableUnchanged
implements CreateCommit.Unchanged {
    private final StoreKey key;
    private final int payload;
    @Nullable
    private final ObjId expectedValue;
    @Nullable
    private final UUID contentId;

    private ImmutableUnchanged(StoreKey key, int payload, @Nullable ObjId expectedValue, @Nullable UUID contentId) {
        this.key = Objects.requireNonNull(key, "key");
        this.payload = payload;
        this.expectedValue = expectedValue;
        this.contentId = contentId;
    }

    private ImmutableUnchanged(ImmutableUnchanged original, StoreKey key, int payload, @Nullable ObjId expectedValue, @Nullable UUID contentId) {
        this.key = key;
        this.payload = payload;
        this.expectedValue = expectedValue;
        this.contentId = contentId;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    public int payload() {
        return this.payload;
    }

    @Override
    @Nullable
    public ObjId expectedValue() {
        return this.expectedValue;
    }

    @Override
    @Nullable
    public UUID contentId() {
        return this.contentId;
    }

    public final ImmutableUnchanged withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableUnchanged(this, newValue, this.payload, this.expectedValue, this.contentId);
    }

    public final ImmutableUnchanged withPayload(int value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableUnchanged(this, this.key, value, this.expectedValue, this.contentId);
    }

    public final ImmutableUnchanged withExpectedValue(@Nullable ObjId value) {
        if (this.expectedValue == value) {
            return this;
        }
        return new ImmutableUnchanged(this, this.key, this.payload, value, this.contentId);
    }

    public final ImmutableUnchanged withContentId(@Nullable UUID value) {
        if (this.contentId == value) {
            return this;
        }
        return new ImmutableUnchanged(this, this.key, this.payload, this.expectedValue, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUnchanged && this.equalsByValue((ImmutableUnchanged)another);
    }

    private boolean equalsByValue(ImmutableUnchanged another) {
        return this.key.equals(another.key) && this.payload == another.payload && Objects.equals(this.expectedValue, another.expectedValue) && Objects.equals(this.contentId, another.contentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.payload;
        h += (h << 5) + Objects.hashCode(this.expectedValue);
        h += (h << 5) + Objects.hashCode(this.contentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Unchanged").omitNullValues().add("key", (Object)this.key).add("payload", this.payload).add("expectedValue", (Object)this.expectedValue).add("contentId", (Object)this.contentId).toString();
    }

    public static ImmutableUnchanged of(StoreKey key, int payload, @Nullable ObjId expectedValue, @Nullable UUID contentId) {
        return new ImmutableUnchanged(key, payload, expectedValue, contentId);
    }

    public static ImmutableUnchanged copyOf(CreateCommit.Unchanged instance) {
        if (instance instanceof ImmutableUnchanged) {
            return (ImmutableUnchanged)instance;
        }
        return ImmutableUnchanged.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateCommit.Unchanged", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private long initBits = 3L;
        private StoreKey key;
        private int payload;
        private ObjId expectedValue;
        private UUID contentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateCommit.Unchanged instance) {
            UUID contentIdValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.payload(instance.payload());
            ObjId expectedValueValue = instance.expectedValue();
            if (expectedValueValue != null) {
                this.expectedValue(expectedValueValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(int payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedValue(@Nullable ObjId expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@Nullable UUID contentId) {
            this.contentId = contentId;
            return this;
        }

        public ImmutableUnchanged build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUnchanged(null, this.key, this.payload, this.expectedValue, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build Unchanged, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

