/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepositoryDescription", generator="Immutables")
@Immutable
public final class ImmutableRepositoryDescription
implements RepositoryDescription {
    private final Instant repositoryCreatedTime;
    private final Instant oldestPossibleCommitTime;
    private final Map<String, String> properties;
    private final String defaultBranchName;

    private ImmutableRepositoryDescription(Instant repositoryCreatedTime, Instant oldestPossibleCommitTime, Map<String, String> properties, String defaultBranchName) {
        this.repositoryCreatedTime = repositoryCreatedTime;
        this.oldestPossibleCommitTime = oldestPossibleCommitTime;
        this.properties = properties;
        this.defaultBranchName = defaultBranchName;
    }

    @Override
    @JsonProperty(value="repositoryCreatedTime")
    @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
    @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
    public Instant repositoryCreatedTime() {
        return this.repositoryCreatedTime;
    }

    @Override
    @JsonProperty(value="oldestPossibleCommitTime")
    @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
    @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
    public Instant oldestPossibleCommitTime() {
        return this.oldestPossibleCommitTime;
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="defaultBranchName")
    public String defaultBranchName() {
        return this.defaultBranchName;
    }

    public final ImmutableRepositoryDescription withRepositoryCreatedTime(Instant value) {
        if (this.repositoryCreatedTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "repositoryCreatedTime");
        return new ImmutableRepositoryDescription(newValue, this.oldestPossibleCommitTime, this.properties, this.defaultBranchName);
    }

    public final ImmutableRepositoryDescription withOldestPossibleCommitTime(Instant value) {
        if (this.oldestPossibleCommitTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "oldestPossibleCommitTime");
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, newValue, this.properties, this.defaultBranchName);
    }

    public final ImmutableRepositoryDescription withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRepositoryDescription.createUnmodifiableMap(true, false, entries);
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, newValue, this.defaultBranchName);
    }

    public final ImmutableRepositoryDescription withDefaultBranchName(String value) {
        String newValue = Objects.requireNonNull(value, "defaultBranchName");
        if (this.defaultBranchName.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, this.properties, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryDescription && this.equalTo(0, (ImmutableRepositoryDescription)another);
    }

    private boolean equalTo(int synthetic, ImmutableRepositoryDescription another) {
        return this.repositoryCreatedTime.equals(another.repositoryCreatedTime) && this.oldestPossibleCommitTime.equals(another.oldestPossibleCommitTime) && this.properties.equals(another.properties) && this.defaultBranchName.equals(another.defaultBranchName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repositoryCreatedTime.hashCode();
        h += (h << 5) + this.oldestPossibleCommitTime.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.defaultBranchName.hashCode();
        return h;
    }

    public String toString() {
        return "RepositoryDescription{repositoryCreatedTime=" + this.repositoryCreatedTime + ", oldestPossibleCommitTime=" + this.oldestPossibleCommitTime + ", properties=" + this.properties + ", defaultBranchName=" + this.defaultBranchName + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryDescription fromJson(Json json) {
        Builder builder = ImmutableRepositoryDescription.builder();
        if (json.repositoryCreatedTime != null) {
            builder.repositoryCreatedTime(json.repositoryCreatedTime);
        }
        if (json.oldestPossibleCommitTime != null) {
            builder.oldestPossibleCommitTime(json.oldestPossibleCommitTime);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        if (json.defaultBranchName != null) {
            builder.defaultBranchName(json.defaultBranchName);
        }
        return builder.build();
    }

    public static ImmutableRepositoryDescription copyOf(RepositoryDescription instance) {
        if (instance instanceof ImmutableRepositoryDescription) {
            return (ImmutableRepositoryDescription)instance;
        }
        return ImmutableRepositoryDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RepositoryDescription", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements RepositoryDescription.Builder {
        private static final long INIT_BIT_REPOSITORY_CREATED_TIME = 1L;
        private static final long INIT_BIT_OLDEST_POSSIBLE_COMMIT_TIME = 2L;
        private static final long INIT_BIT_DEFAULT_BRANCH_NAME = 4L;
        private long initBits = 7L;
        @Nullable
        private Instant repositoryCreatedTime;
        @Nullable
        private Instant oldestPossibleCommitTime;
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        @Nullable
        private String defaultBranchName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.repositoryCreatedTime(instance.repositoryCreatedTime());
            this.oldestPossibleCommitTime(instance.oldestPossibleCommitTime());
            this.putAllProperties(instance.properties());
            this.defaultBranchName(instance.defaultBranchName());
            return this;
        }

        @Override
        @JsonProperty(value="repositoryCreatedTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder repositoryCreatedTime(Instant repositoryCreatedTime) {
            this.repositoryCreatedTime = Objects.requireNonNull(repositoryCreatedTime, "repositoryCreatedTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="oldestPossibleCommitTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder oldestPossibleCommitTime(Instant oldestPossibleCommitTime) {
            this.oldestPossibleCommitTime = Objects.requireNonNull(oldestPossibleCommitTime, "oldestPossibleCommitTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), value == null ? Objects.requireNonNull(value, "properties value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties((Map)entries);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "properties value for key: " + k) : v);
            }
            return this;
        }

        @Override
        @JsonProperty(value="defaultBranchName")
        @CanIgnoreReturnValue
        public final Builder defaultBranchName(String defaultBranchName) {
            this.defaultBranchName = Objects.requireNonNull(defaultBranchName, "defaultBranchName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableRepositoryDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, ImmutableRepositoryDescription.createUnmodifiableMap(false, false, this.properties), this.defaultBranchName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repositoryCreatedTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("oldestPossibleCommitTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultBranchName");
            }
            return "Cannot build RepositoryDescription, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepositoryDescription", generator="Immutables")
    static final class Json
    implements RepositoryDescription {
        @Nullable
        Instant repositoryCreatedTime;
        @Nullable
        Instant oldestPossibleCommitTime;
        @Nullable
        Map<String, String> properties = Collections.emptyMap();
        @Nullable
        String defaultBranchName;

        Json() {
        }

        @JsonProperty(value="repositoryCreatedTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        public void setRepositoryCreatedTime(Instant repositoryCreatedTime) {
            this.repositoryCreatedTime = repositoryCreatedTime;
        }

        @JsonProperty(value="oldestPossibleCommitTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        public void setOldestPossibleCommitTime(Instant oldestPossibleCommitTime) {
            this.oldestPossibleCommitTime = oldestPossibleCommitTime;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        @JsonProperty(value="defaultBranchName")
        public void setDefaultBranchName(String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
        }

        @Override
        public Instant repositoryCreatedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant oldestPossibleCommitTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String defaultBranchName() {
            throw new UnsupportedOperationException();
        }
    }
}

