/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.CommitWrappedException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitConflict;
import org.projectnessie.versioned.storage.common.logic.CommitRetry;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;

final class ReferenceLogicImpl
implements ReferenceLogic {
    private final Persist persist;

    ReferenceLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public List<Reference> getReferences(@javax.annotation.Nonnull @Nonnull List<String> references) {
        Reference[] refs = this.persist.fetchReferences(references.toArray(new String[0]));
        ArrayList<Reference> r = new ArrayList<Reference>(refs.length);
        Supplier<StoreIndex<CommitOp>> refsIndexSupplier = this.createRefsIndexSupplier();
        for (int i = 0; i < refs.length; ++i) {
            Reference ref = refs[i];
            ref = this.maybeRecover(references.get(i), ref, refsIndexSupplier);
            if (ref != null && ref.name().startsWith("int/")) {
                ref = null;
            }
            r.add(ref);
        }
        return r;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<Reference, String> queryReferences(@javax.annotation.Nonnull @Nonnull ReferencesQuery referencesQuery) {
        Optional<PagingToken> pagingToken = referencesQuery.pagingToken();
        StoreKey prefix = referencesQuery.referencePrefix().map(StoreKey::keyFromString).orElse(null);
        StoreKey begin = pagingToken.map(PagingToken::token).map(ByteString::toStringUtf8).map(xva$0 -> StoreKey.key(xva$0)).orElse(prefix);
        StoreIndex<CommitOp> index = this.createRefsIndexSupplier().get();
        return new QueryIter(index, prefix, begin, referencesQuery.prefetch());
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Reference createReference(@javax.annotation.Nonnull @Nonnull String name, @javax.annotation.Nonnull @Nonnull ObjId pointer) throws RefAlreadyExistsException, RetryTimeoutException {
        Preconditions.checkArgument((!Reference.isInternalReferenceName(name) ? 1 : 0) != 0);
        block7: while (true) {
            CommitReferenceResult commitToIndex = this.commitCreateReference(name, pointer);
            Reference reference = commitToIndex.reference;
            switch (commitToIndex.kind) {
                case ADDED_TO_INDEX: {
                    Preconditions.checkState((!reference.deleted() ? 1 : 0) != 0, (Object)"internal error");
                    try {
                        return this.persist.addReference(reference);
                    }
                    catch (RefAlreadyExistsException e) {
                        Reference existing = e.reference();
                        if (existing == null || existing.deleted()) continue block7;
                        throw e;
                    }
                }
                case REF_ROW_MISSING: {
                    Preconditions.checkState((!reference.deleted() ? 1 : 0) != 0, (Object)"internal error");
                    reference = this.persist.addReference(reference);
                    throw new RefAlreadyExistsException(reference);
                }
                case REF_ROW_EXISTS: {
                    if (!reference.deleted()) {
                        throw new RefAlreadyExistsException(reference);
                    }
                    this.maybeRecover(name, reference, this.createRefsIndexSupplier());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void deleteReference(@javax.annotation.Nonnull @Nonnull String name, @javax.annotation.Nonnull @Nonnull ObjId expectedPointer) throws RefNotFoundException, RefConditionFailedException, RetryTimeoutException {
        Supplier<StoreIndex<CommitOp>> indexSupplier;
        Preconditions.checkArgument((!Reference.isInternalReferenceName(name) ? 1 : 0) != 0);
        Reference reference = this.persist.fetchReference(name);
        if (reference == null) {
            StoreKey nameKey = StoreKey.key(name);
            indexSupplier = this.createRefsIndexSupplier();
            StoreIndexElement<CommitOp> index = indexSupplier.get().get(nameKey);
            if (index == null) {
                throw new RefNotFoundException(Reference.reference(name, expectedPointer, false));
            }
            reference = this.maybeRecover(name, null, indexSupplier);
            if (reference == null) {
                throw new RefNotFoundException(Reference.reference(name, expectedPointer, false));
            }
        }
        boolean actAsAlreadyDeleted = reference.deleted();
        if (!reference.pointer().equals(expectedPointer) && !actAsAlreadyDeleted) {
            indexSupplier = this.createRefsIndexSupplier();
            Reference recovered = this.maybeRecover(name, reference, indexSupplier);
            throw new RefConditionFailedException(recovered != null ? recovered : reference);
        }
        if (!actAsAlreadyDeleted) {
            this.persist.markReferenceAsDeleted(reference);
        }
        this.commitDeleteReference(reference);
        this.persist.purgeReference(reference);
        if (actAsAlreadyDeleted) {
            throw new RefNotFoundException(Reference.reference(name, expectedPointer, false));
        }
    }

    @VisibleForTesting
    CommitReferenceResult commitCreateReference(String name, ObjId pointer) throws RetryTimeoutException {
        try {
            return CommitRetry.commitRetry(this.persist, (p, retryState) -> {
                Reference refRefs = Objects.requireNonNull(p.fetchReference(InternalRef.REF_REFS.name()));
                long created = p.config().currentTimeMicros();
                RefObj ref = RefObj.ref(name, pointer, created);
                try {
                    p.storeObj(ref);
                }
                catch (ObjTooLargeException e) {
                    throw new RuntimeException(e);
                }
                StoreKey k = StoreKey.key(name);
                Instant now = this.persist.config().clock().instant();
                CreateCommit c = CreateCommit.newCommitBuilder().message("Create reference " + name + " pointing to " + pointer).parentCommitId(refRefs.pointer()).addAdds(CreateCommit.Add.commitAdd(k, 0, Objects.requireNonNull(ref.id()), null, null)).headers(CommitHeaders.newCommitHeaders().add("operation", "create").add("name", name).add("head", pointer.toString()).add("timestamp", now.toString()).add("timestamp.millis", Long.toString(now.toEpochMilli())).build()).commitType(CommitType.INTERNAL).build();
                ReferenceLogicImpl.commitReferenceChange(p, refRefs, c);
                return new CommitReferenceResult(Reference.reference(name, pointer, false), CommitReferenceResult.Kind.ADDED_TO_INDEX);
            });
        }
        catch (CommitConflictException e) {
            RefObj ref;
            Preconditions.checkState((e.conflicts().size() == 1 ? 1 : 0) != 0, (String)"Unexpected amount of conflicts %s", e.conflicts());
            CommitConflict conflict = e.conflicts().get(0);
            Preconditions.checkState((conflict.conflictType() == CommitConflict.ConflictType.KEY_EXISTS ? 1 : 0) != 0, (String)"Unexpected conflict type %s", (Object)conflict);
            Supplier<StoreIndex<CommitOp>> indexSupplier = this.createRefsIndexSupplier();
            StoreIndexElement<CommitOp> el = indexSupplier.get().get(StoreKey.key(name));
            Preconditions.checkNotNull(el, (String)"Key %s missing in index", (Object)name);
            Reference existing = this.persist.fetchReference(name);
            if (existing != null) {
                return new CommitReferenceResult(existing, CommitReferenceResult.Kind.REF_ROW_EXISTS);
            }
            try {
                ref = this.persist.fetchTypedObj(Objects.requireNonNull(el.content().value(), "Reference commit operation has no value"), ObjType.REF, RefObj.class);
            }
            catch (ObjNotFoundException ex) {
                throw new RuntimeException("Internal error getting reference creation object", e);
            }
            return new CommitReferenceResult(Reference.reference(name, ref.initialPointer(), false), CommitReferenceResult.Kind.REF_ROW_MISSING);
        }
        catch (CommitWrappedException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the creation of the reference '%s'", Reference.reference(name, pointer, false)), e.getCause());
        }
    }

    @VisibleForTesting
    void commitDeleteReference(Reference reference) throws RetryTimeoutException {
        try {
            CommitRetry.commitRetry(this.persist, (p, retryState) -> {
                CommitOp indexElementContent;
                CommitObj commit;
                Reference refRefs = Objects.requireNonNull(p.fetchReference(InternalRef.REF_REFS.name()));
                try {
                    commit = p.fetchTypedObj(refRefs.pointer(), ObjType.COMMIT, CommitObj.class);
                }
                catch (ObjNotFoundException e) {
                    throw new RuntimeException("Internal error getting reference creation log commit", e);
                }
                StoreIndex<CommitOp> index = Logics.indexesLogic(this.persist).incrementalIndexForUpdate(commit, Optional.empty());
                StoreKey key = StoreKey.key(reference.name());
                StoreIndexElement<CommitOp> indexElement = index.get(key);
                if (indexElement != null && (indexElementContent = indexElement.content()).action().exists()) {
                    Instant now = this.persist.config().clock().instant();
                    CreateCommit c = CreateCommit.newCommitBuilder().message("Drop reference " + reference.name() + " pointing to " + reference.pointer()).parentCommitId(refRefs.pointer()).addRemoves(CreateCommit.Remove.commitRemove(key, 0, Objects.requireNonNull(indexElementContent.value()), indexElementContent.contentId())).headers(CommitHeaders.newCommitHeaders().add("operation", "delete").add("name", reference.name()).add("head", reference.pointer().toString()).add("timestamp", now.toString()).add("timestamp.millis", Long.toString(now.toEpochMilli())).build()).commitType(CommitType.INTERNAL).build();
                    ReferenceLogicImpl.commitReferenceChange(p, refRefs, c);
                }
                return null;
            });
        }
        catch (CommitConflictException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the deletion of the reference '%s'", reference), e);
        }
        catch (CommitWrappedException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the deletion of the reference '%s'", reference), e.getCause());
        }
    }

    private static void commitReferenceChange(Persist p, Reference refRefs, CreateCommit c) throws CommitConflictException, CommitRetry.RetryException {
        ObjId commitId;
        try {
            commitId = Logics.commitLogic(p).doCommit(c, Collections.emptyList());
        }
        catch (ObjNotFoundException e) {
            throw new RuntimeException("Internal error committing to log of references", e);
        }
        Preconditions.checkState((commitId != null ? 1 : 0) != 0);
        try {
            p.updateReferencePointer(refRefs, commitId);
        }
        catch (RefConditionFailedException e) {
            throw new CommitRetry.RetryException();
        }
        catch (RefNotFoundException e) {
            throw new RuntimeException("Internal reference not found", e);
        }
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Reference assignReference(@javax.annotation.Nonnull @Nonnull Reference current, @javax.annotation.Nonnull @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Preconditions.checkArgument((!current.isInternal() ? 1 : 0) != 0);
        return this.persist.updateReferencePointer(current, newPointer);
    }

    private Reference maybeRecover(@javax.annotation.Nonnull @Nonnull String name, Reference ref, @javax.annotation.Nonnull @Nonnull Supplier<StoreIndex<CommitOp>> refsIndexSupplier) {
        if (ref == null) {
            StoreIndexElement<CommitOp> commitOp = refsIndexSupplier.get().get(StoreKey.key(name));
            if (commitOp == null) {
                return null;
            }
            CommitOp commitOpContent = commitOp.content();
            if (commitOpContent.action().exists()) {
                RefObj initialRef;
                try {
                    initialRef = this.persist.fetchTypedObj(Objects.requireNonNull(commitOpContent.value(), "Reference commit operation has no value"), ObjType.REF, RefObj.class);
                }
                catch (ObjNotFoundException e) {
                    throw new RuntimeException("Internal error getting reference creation object", e);
                }
                ref = Reference.reference(name, initialRef.initialPointer(), false);
                try {
                    ref = this.persist.addReference(ref);
                }
                catch (RefAlreadyExistsException e) {
                    ref = e.reference();
                }
                return ref;
            }
            return null;
        }
        if (ref.deleted()) {
            StoreIndexElement<CommitOp> commitOp = refsIndexSupplier.get().get(StoreKey.key(name));
            if (commitOp == null) {
                throw new RuntimeException("Loaded Reference is marked as deleted, but not found in index");
            }
            CommitOp commitOpContent = commitOp.content();
            if (commitOpContent.action().exists()) {
                try {
                    this.commitDeleteReference(ref);
                    this.persist.purgeReference(ref);
                }
                catch (RefNotFoundException initialRef) {
                }
                catch (RefConditionFailedException | RetryTimeoutException e) {
                    throw new RuntimeException(e);
                }
            } else {
                try {
                    this.persist.purgeReference(ref);
                }
                catch (RefNotFoundException e) {
                }
                catch (RefConditionFailedException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
        return ref;
    }

    @VisibleForTesting
    Supplier<StoreIndex<CommitOp>> createRefsIndexSupplier() {
        return Logics.indexesLogic(this.persist).createIndexSupplier(() -> {
            Reference ref = this.persist.fetchReference(InternalRef.REF_REFS.name());
            return ref != null ? ref.pointer() : ObjId.EMPTY_OBJ_ID;
        });
    }

    static final class CommitReferenceResult {
        final Reference reference;
        final Kind kind;

        CommitReferenceResult(Reference reference, Kind kind) {
            this.reference = reference;
            this.kind = kind;
        }

        static enum Kind {
            ADDED_TO_INDEX,
            REF_ROW_EXISTS,
            REF_ROW_MISSING;

        }
    }

    private final class QueryIter
    extends AbstractIterator<Reference>
    implements PagedResult<Reference, String> {
        private final StoreIndex<CommitOp> index;
        private final Iterator<StoreIndexElement<CommitOp>> base;
        private final StoreKey prefix;

        private QueryIter(StoreIndex<CommitOp> index, StoreKey prefix, StoreKey begin, boolean prefetch) {
            this.index = index;
            this.prefix = prefix;
            this.base = index.iterator(begin, null, prefetch);
        }

        protected Reference computeNext() {
            StoreIndexElement<CommitOp> el;
            StoreKey k;
            String name;
            Reference r;
            do {
                if (!this.base.hasNext()) {
                    return (Reference)this.endOfData();
                }
                el = this.base.next();
                k = el.key();
                if (this.prefix == null || k.startsWith(this.prefix)) continue;
                return (Reference)this.endOfData();
            } while ((r = ReferenceLogicImpl.this.maybeRecover(name = k.rawString(), ReferenceLogicImpl.this.persist.fetchReference(el.key().rawString()), () -> this.index)) == null);
            return r;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public PagingToken tokenForKey(String key) {
            return key != null ? PagingToken.pagingToken(ByteString.copyFromUtf8((String)key)) : PagingToken.emptyPagingToken();
        }
    }
}

