/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;

final class CommitHeadersImpl
implements CommitHeaders {
    private final Map<String, List<String>> map;

    private CommitHeadersImpl(Map<String, List<String>> map) {
        this.map = map;
    }

    static CommitHeaders.Builder builder() {
        return new BuilderImpl(new HashMap<String, List<String>>());
    }

    @Override
    public String getFirst(String name) {
        List<String> el = this.map.get(CommitHeadersImpl.lowerCase(name));
        if (el == null) {
            return null;
        }
        return el.get(0);
    }

    @Override
    public List<String> getAll(String name) {
        List<String> el = this.map.get(CommitHeadersImpl.lowerCase(name));
        if (el == null) {
            return null;
        }
        return Collections.unmodifiableList(el);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    static String lowerCase(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommitHeadersImpl)) {
            return false;
        }
        CommitHeadersImpl o = (CommitHeadersImpl)obj;
        return this.map.equals(o.map);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CommitHeaders{");
        boolean first = true;
        for (Map.Entry<String, List<String>> e : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(e.getKey()).append("=[");
            boolean f = true;
            for (String v : e.getValue()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(",");
                }
                sb.append(v);
            }
            sb.append(']');
        }
        return sb.append('}').toString();
    }

    static final class BuilderImpl
    implements CommitHeaders.Builder {
        private final Map<String, List<String>> map;

        public BuilderImpl(Map<String, List<String>> map) {
            this.map = map;
        }

        @Override
        public CommitHeaders.Builder add(String name, String value) {
            this.nameList(name).add(value);
            return this;
        }

        @Override
        public CommitHeaders.Builder from(CommitHeaders headers) {
            CommitHeadersImpl h = (CommitHeadersImpl)headers;
            for (Map.Entry e : h.map.entrySet()) {
                this.nameList((String)e.getKey()).addAll((Collection)e.getValue());
            }
            return this;
        }

        private List<String> nameList(String name) {
            return this.map.computeIfAbsent(CommitHeadersImpl.lowerCase(name), x -> new ArrayList());
        }

        @Override
        public CommitHeaders build() {
            return new CommitHeadersImpl(new HashMap<String, List<String>>(this.map));
        }
    }
}

