/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="IndexObj", generator="Immutables")
@Immutable
public final class ImmutableIndexObj
implements IndexObj {
    @jakarta.annotation.Nullable
    private final ObjId id;
    private final ByteString index;

    private ImmutableIndexObj(@jakarta.annotation.Nullable ObjId id, ByteString index) {
        this.id = id;
        this.index = Objects.requireNonNull(index, "index");
    }

    private ImmutableIndexObj(ImmutableIndexObj original, @jakarta.annotation.Nullable ObjId id, ByteString index) {
        this.id = id;
        this.index = index;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public ByteString index() {
        return this.index;
    }

    public final ImmutableIndexObj withId(@jakarta.annotation.Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableIndexObj(this, value, this.index);
    }

    public final ImmutableIndexObj withIndex(ByteString value) {
        if (this.index == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "index");
        return new ImmutableIndexObj(this, this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexObj && this.equalTo(0, (ImmutableIndexObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableIndexObj another) {
        return Objects.equals(this.id, another.id) && this.index.equals((Object)another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IndexObj").omitNullValues().add("id", (Object)this.id).add("index", (Object)this.index).toString();
    }

    public static ImmutableIndexObj of(@jakarta.annotation.Nullable ObjId id, ByteString index) {
        return new ImmutableIndexObj(id, index);
    }

    public static ImmutableIndexObj copyOf(IndexObj instance) {
        if (instance instanceof ImmutableIndexObj) {
            return (ImmutableIndexObj)instance;
        }
        return ImmutableIndexObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IndexObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private long initBits = 1L;
        @Nullable
        private ObjId id;
        @Nullable
        private ByteString index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IndexObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ObjId idValue;
            Obj instance;
            long bits = 0L;
            if (object instanceof IndexObj) {
                instance = (IndexObj)object;
                this.index(instance.index());
                if ((bits & 1L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@jakarta.annotation.Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(ByteString index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableIndexObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndexObj(null, this.id, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build IndexObj, some of required attributes are not set " + attributes;
        }
    }
}

