/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableRefObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface RefObj
extends Obj {
    @Override
    default public ObjType type() {
        return ObjType.REF;
    }

    @Value.Parameter(order=1)
    public String name();

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public ObjId initialPointer();

    @Value.Parameter(order=3)
    public long createdAtMicros();

    public static RefObj ref(ObjId id, String name, ObjId initialPointer, long createdAtMicros) {
        return ImmutableRefObj.of(name, id, initialPointer, createdAtMicros);
    }

    public static RefObj ref(String name, ObjId initialPointer, long createdAtMicros) {
        return RefObj.ref(Hashes.refHash(name, initialPointer, createdAtMicros), name, initialPointer, createdAtMicros);
    }
}

