/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class JdkSpecifics {
    public static final JdkSpecific JDK_SPECIFIC;

    static {
        JdkSpecific m;
        try {
            m = new Java11();
            m.mismatch(ByteBuffer.wrap("hello".getBytes(StandardCharsets.UTF_8)), ByteBuffer.wrap("world".getBytes(StandardCharsets.UTF_8)));
        }
        catch (Throwable t) {
            m = new Java8();
        }
        JDK_SPECIFIC = m;
    }

    @VisibleForTesting
    static final class Java8
    implements JdkSpecific {
        Java8() {
        }

        @Override
        public int mismatch(ByteBuffer b1, ByteBuffer b2) {
            int l1 = b1.limit();
            int l2 = b2.limit();
            int p1 = b1.position();
            int p2 = b2.position();
            int i = 0;
            byte v2;
            byte v1;
            while (p1 < l1 && p2 < l2 && (v1 = b1.get(p1)) == (v2 = b2.get(p2))) {
                ++i;
                ++p1;
                ++p2;
            }
            return p1 == l1 && p2 == l2 ? -1 : i;
        }

        public String toString() {
            return "JdkSpecific.Java8";
        }
    }

    @VisibleForTesting
    static final class Java11
    implements JdkSpecific {
        Java11() {
        }

        @Override
        public int mismatch(ByteBuffer b1, ByteBuffer b2) {
            return b1.mismatch(b2);
        }

        public String toString() {
            return "JdkSpecific.Java11";
        }
    }

    public static interface JdkSpecific {
        public int mismatch(ByteBuffer var1, ByteBuffer var2);
    }
}

