/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public final class Ser {
    public static final ObjectMapper SHARED_OBJECT_MAPPER = new ObjectMapper();

    private Ser() {
    }

    public static int varIntLen(int v) {
        Preconditions.checkArgument((v >= 0 ? 1 : 0) != 0);
        v &= Integer.MAX_VALUE;
        int l = 0;
        while (true) {
            ++l;
            if (v <= 127) {
                return l;
            }
            v >>= 7;
        }
    }

    public static ByteBuffer putVarInt(ByteBuffer b, int v) {
        Preconditions.checkArgument((v >= 0 ? 1 : 0) != 0);
        v &= Integer.MAX_VALUE;
        while (v > 127) {
            b.put((byte)(v | 0x80));
            v >>= 7;
        }
        return b.put((byte)v);
    }

    public static int readVarInt(ByteBuffer b) {
        int r = 0;
        int shift = 0;
        while (true) {
            int v = b.get() & 0xFF;
            r |= (v & 0x7F) << shift;
            if ((v & 0x80) == 0) break;
            shift += 7;
        }
        return r;
    }
}

