/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;

final class LayeredIndexImpl<V>
implements StoreIndex<V> {
    private final StoreIndex<V> reference;
    private final StoreIndex<V> updates;

    LayeredIndexImpl(StoreIndex<V> reference, StoreIndex<V> updates) {
        this.reference = reference;
        this.updates = updates;
    }

    @Override
    public boolean isModified() {
        return this.updates.isModified() || this.reference.isModified();
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        this.reference.loadIfNecessary(keys);
        this.updates.loadIfNecessary(keys);
        return this;
    }

    @Override
    public boolean isLoaded() {
        return this.reference.isLoaded() && this.updates.isLoaded();
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        throw new UnsupportedOperationException("Layered instance cannot be resolved");
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        throw new UnsupportedOperationException("Operation not supported for non-mutable indexes");
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return Collections.singletonList(this);
    }

    @Override
    public int elementCount() {
        int cnt = 0;
        for (StoreIndexElement ignore : this) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public List<StoreKey> asKeyList() {
        ArrayList<StoreKey> keys = new ArrayList<StoreKey>();
        for (StoreIndexElement el : this) {
            keys.add(el.key());
        }
        return keys;
    }

    @Override
    public int estimatedSerializedSize() {
        return this.reference.estimatedSerializedSize() + this.updates.estimatedSerializedSize();
    }

    @Override
    public boolean contains(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        return this.updates.contains(key) || this.reference.contains(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreIndexElement<V> get(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        StoreIndexElement<V> v = this.updates.get(key);
        return v != null ? v : this.reference.get(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey first() {
        StoreKey f = this.reference.first();
        StoreKey i = this.updates.first();
        if (f == null) {
            return i;
        }
        if (i == null) {
            return f;
        }
        return f.compareTo(i) < 0 ? f : i;
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey last() {
        StoreKey f = this.reference.last();
        StoreKey i = this.updates.last();
        if (f == null) {
            return i;
        }
        if (i == null) {
            return f;
        }
        return f.compareTo(i) > 0 ? f : i;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(final @Nullable @jakarta.annotation.Nullable StoreKey begin, final @Nullable @jakarta.annotation.Nullable StoreKey end, final boolean prefetch) {
        return new AbstractIterator<StoreIndexElement<V>>(){
            final Iterator<StoreIndexElement<V>> fullIter;
            final Iterator<StoreIndexElement<V>> incrementalIter;
            StoreIndexElement<V> fullElement;
            StoreIndexElement<V> incrementalElement;
            {
                this.fullIter = LayeredIndexImpl.this.reference.iterator(begin, end, prefetch);
                this.incrementalIter = LayeredIndexImpl.this.updates.iterator(begin, end, prefetch);
            }

            protected StoreIndexElement<V> computeNext() {
                int cmp;
                if (this.fullElement == null && this.fullIter.hasNext()) {
                    this.fullElement = this.fullIter.next();
                }
                if (this.incrementalElement == null && this.incrementalIter.hasNext()) {
                    this.incrementalElement = this.incrementalIter.next();
                }
                if (this.incrementalElement == null) {
                    if (this.fullElement == null) {
                        return (StoreIndexElement)this.endOfData();
                    }
                    cmp = -1;
                } else {
                    cmp = this.fullElement == null ? 1 : this.fullElement.key().compareTo(this.incrementalElement.key());
                }
                if (cmp == 0) {
                    this.fullElement = null;
                    return this.returnIncremental();
                }
                if (cmp < 0) {
                    return this.returnFull();
                }
                return this.returnIncremental();
            }

            private StoreIndexElement<V> returnFull() {
                StoreIndexElement e = this.fullElement;
                this.fullElement = null;
                return e;
            }

            private StoreIndexElement<V> returnIncremental() {
                StoreIndexElement e = this.incrementalElement;
                this.incrementalElement = null;
                return e;
            }
        };
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ByteString serialize() {
        throw LayeredIndexImpl.unsupported();
    }

    @Override
    public boolean add(@javax.annotation.Nonnull @Nonnull StoreIndexElement<V> element) {
        throw LayeredIndexImpl.unsupported();
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
        throw LayeredIndexImpl.unsupported();
    }

    @Override
    public boolean remove(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        throw LayeredIndexImpl.unsupported();
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Layered indexes do not support updates");
    }
}

