/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.logic.StringLogic;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;

final class StringLogicImpl
implements StringLogic {
    private final Persist persist;

    StringLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    public StringLogic.StringValue fetchString(ObjId stringObjId) throws ObjNotFoundException {
        return this.fetchString(this.persist.fetchTypedObj(stringObjId, ObjType.STRING, StringObj.class));
    }

    @Override
    public StringLogic.StringValue fetchString(StringObj stringObj) {
        Preconditions.checkState((stringObj.compression() == Compression.NONE ? 1 : 0) != 0, (String)"Unsupported compression %s", (Object)((Object)stringObj.compression()));
        Preconditions.checkState((boolean)stringObj.predecessors().isEmpty(), (Object)"Predecessors in StringObj are not yet supported");
        return new StringValueHolder(stringObj);
    }

    @Override
    public StringObj updateString(StringLogic.StringValue previousValue, String contentType, byte[] stringValueUtf8) {
        ByteString text = UnsafeByteOperations.unsafeWrap((byte[])stringValueUtf8);
        return StringObj.stringData("application/json", Compression.NONE, null, Collections.emptyList(), text);
    }

    @Override
    public StringObj updateString(StringLogic.StringValue previousValue, String contentType, String stringValue) {
        return this.updateString(previousValue, contentType, stringValue.getBytes(StandardCharsets.UTF_8));
    }

    static final class StringValueHolder
    implements StringLogic.StringValue {
        final StringObj obj;

        StringValueHolder(StringObj obj) {
            this.obj = obj;
        }

        @Override
        public String contentType() {
            return this.obj.contentType();
        }

        @Override
        public String completeValue() throws ObjNotFoundException {
            return this.obj.text().toStringUtf8();
        }

        @Override
        public ObjId objId() {
            return this.obj.id();
        }
    }
}

