/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.persist.ImmutableReference;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public interface Reference {
    public static final String INTERNAL_PREFIX = "int/";

    @Value.Parameter(order=2)
    public String name();

    @Value.Parameter(order=3)
    public ObjId pointer();

    @Value.Parameter(order=4)
    public boolean deleted();

    @Value.Parameter(order=5)
    public long createdAtMicros();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=6)
    public ObjId extendedInfoObj();

    default public Reference forNewPointer(ObjId newPointer) {
        return ImmutableReference.builder().from(this).deleted(false).pointer(newPointer).build();
    }

    public Reference withDeleted(boolean var1);

    public static Reference reference(String name, ObjId pointer, boolean deleted, long createdAtMicros, ObjId extendedInfoObj) {
        return ImmutableReference.of(name, pointer, deleted, createdAtMicros, extendedInfoObj);
    }

    @Value.NonAttribute
    default public boolean isInternal() {
        return this.name().startsWith(INTERNAL_PREFIX);
    }

    public static boolean isInternalReferenceName(String name) {
        return name.startsWith(INTERNAL_PREFIX);
    }
}

