/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.indexes.IndexLoader;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;

final class StripedIndexImpl<V>
implements StoreIndex<V> {
    private final StoreIndex<V>[] stripes;
    private final StoreKey[] firstLastKeys;
    private final IndexLoader<V> indexLoader;

    StripedIndexImpl(@javax.annotation.Nonnull @Nonnull StoreIndex<V>[] stripes, @javax.annotation.Nonnull @Nonnull StoreKey[] firstLastKeys, IndexLoader<V> indexLoader) {
        Preconditions.checkArgument((stripes.length > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((stripes.length * 2 == firstLastKeys.length ? 1 : 0) != 0, (String)"Number of stripes (%s) must match number of first-last-keys (%s)", (int)stripes.length, (int)firstLastKeys.length);
        for (StoreKey firstLastKey : firstLastKeys) {
            Preconditions.checkArgument((firstLastKey != null ? 1 : 0) != 0, (Object)"firstLastKey must not contain any null element");
        }
        this.stripes = stripes;
        this.firstLastKeys = firstLastKeys;
        this.indexLoader = indexLoader;
    }

    @Override
    public boolean isModified() {
        for (StoreIndex<V> stripe : this.stripes) {
            if (!stripe.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        StoreIndex<V>[] stripes = this.stripes;
        StoreIndex[] indexesToLoad = new StoreIndex[stripes.length];
        int cnt = 0;
        for (StoreKey key : keys) {
            StoreIndex<V> index;
            int idx = this.stripeForExistingKey(key);
            if (idx == -1 || (index = stripes[idx]).isLoaded()) continue;
            indexesToLoad[idx] = index;
            ++cnt;
        }
        if (cnt > 0) {
            this.loadStripes(indexesToLoad);
        }
        return this;
    }

    private void loadStripes(int firstIndex, int lastIndex) {
        StoreIndex<V>[] stripes = this.stripes;
        StoreIndex[] indexesToLoad = new StoreIndex[stripes.length];
        int cnt = 0;
        for (int idx = firstIndex; idx <= lastIndex; ++idx) {
            StoreIndex<V> index = stripes[idx];
            if (index.isLoaded()) continue;
            indexesToLoad[idx] = index;
            ++cnt;
        }
        if (cnt > 0) {
            this.loadStripes(indexesToLoad);
        }
    }

    private void loadStripes(StoreIndex<V>[] indexesToLoad) {
        StoreIndex<V>[] stripes = this.stripes;
        StoreIndex<V>[] loadedIndexes = this.indexLoader.loadIndexes(indexesToLoad);
        for (int i = 0; i < loadedIndexes.length; ++i) {
            StoreIndex<V> loaded = loadedIndexes[i];
            if (loaded == null) continue;
            stripes[i] = loaded;
        }
    }

    @Override
    public boolean isLoaded() {
        StoreIndex<V>[] stripes;
        for (StoreIndex<V> stripe : stripes = this.stripes) {
            if (!stripe.isLoaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        return this;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        throw new UnsupportedOperationException("Striped indexes cannot be further divided");
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return Arrays.asList(this.stripes);
    }

    @Override
    public int elementCount() {
        StoreIndex<V>[] stripes;
        int sum = 0;
        for (StoreIndex<V> stripe : stripes = this.stripes) {
            sum += stripe.elementCount();
        }
        return sum;
    }

    @Override
    public int estimatedSerializedSize() {
        StoreIndex<V>[] stripes;
        int sum = 0;
        for (StoreIndex<V> stripe : stripes = this.stripes) {
            sum += stripe.estimatedSerializedSize();
        }
        return sum;
    }

    @Override
    public boolean contains(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        int i = this.stripeForExistingKey(key);
        if (i == -1) {
            return false;
        }
        return this.stripes[i].contains(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreIndexElement<V> get(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        int i = this.stripeForExistingKey(key);
        if (i == -1) {
            return null;
        }
        return this.stripes[i].get(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey first() {
        return this.stripes[0].first();
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey last() {
        StoreIndex<V>[] s = this.stripes;
        return s[s.length - 1].last();
    }

    @Override
    public List<StoreKey> asKeyList() {
        ArrayList<StoreKey> r = new ArrayList<StoreKey>(this.elementCount());
        for (StoreIndexElement el : this) {
            r.add(el.key());
        }
        return r;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(final @Nullable @jakarta.annotation.Nullable StoreKey begin, @Nullable @jakarta.annotation.Nullable StoreKey end, final boolean prefetch) {
        int stop;
        final StoreIndex[] s = this.stripes;
        boolean prefix = begin != null && begin.equals(end);
        final int start = begin == null ? 0 : this.indexForKey(begin);
        int n = stop = prefix || end == null ? s.length - 1 : this.indexForKey(end);
        if (prefetch) {
            this.loadStripes(start, stop);
        }
        final Predicate<StoreKey> endCheck = prefix ? k -> !k.startsWith(begin) : (end != null ? k -> end.compareTo((StoreKey)k) < 0 : k -> false);
        return new AbstractIterator<StoreIndexElement<V>>(){
            int stripe;
            Iterator<StoreIndexElement<V>> current;
            {
                this.stripe = start;
                this.current = s[start].iterator(begin, null, prefetch);
            }

            protected StoreIndexElement<V> computeNext() {
                while (true) {
                    boolean has;
                    if (has = this.current.hasNext()) {
                        StoreIndexElement v = this.current.next();
                        if (endCheck.test(v.key())) {
                            return (StoreIndexElement)this.endOfData();
                        }
                        return v;
                    }
                    ++this.stripe;
                    if (this.stripe > stop) {
                        return (StoreIndexElement)this.endOfData();
                    }
                    this.current = s[this.stripe].iterator();
                }
            }
        };
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ByteString serialize() {
        throw StripedIndexImpl.unsupported();
    }

    @Override
    public boolean add(@javax.annotation.Nonnull @Nonnull StoreIndexElement<V> element) {
        return this.mutableStripe(element.key()).add(element);
    }

    @Override
    public boolean remove(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        return this.mutableStripe(key).remove(key);
    }

    private StoreIndex<V> mutableStripe(StoreKey key) {
        int i = this.indexForKey(key);
        StoreIndex<V> stripe = this.stripes[i];
        if (!stripe.isMutable()) {
            stripe = stripe.asMutableIndex();
            this.stripes[i] = stripe;
        }
        return stripe;
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
        throw StripedIndexImpl.unsupported();
    }

    private int stripeForExistingKey(StoreKey key) {
        Object[] firstLast = this.firstLastKeys;
        int i = Arrays.binarySearch(firstLast, key);
        if (i < 0 && ((i = -i - 1) & 1) == 0) {
            return -1;
        }
        if (i == firstLast.length) {
            return -1;
        }
        return i /= 2;
    }

    private int indexForKey(StoreKey key) {
        Object[] firstLast = this.firstLastKeys;
        int i = Arrays.binarySearch(firstLast, key);
        if (i < 0) {
            i = -i - 1;
        }
        return Math.min(i / 2, firstLast.length / 2 - 1);
    }

    private static UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Striped indexes do not support this operation");
    }
}

