/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableInternalRef;

@Value.Immutable
public interface InternalRef {
    public static final InternalRef REF_REFS = InternalRef.internalReference("refs");
    public static final InternalRef REF_REPO = InternalRef.internalReference("repo");
    public static final StoreKey KEY_REPO_DESCRIPTION = StoreKey.key("repo", "description");

    @Value.Parameter(order=1)
    public String name();

    public static InternalRef internalReference(String name) {
        return ImmutableInternalRef.of("int/" + name);
    }

    public static List<InternalRef> allInternalRefs() {
        return Collections.unmodifiableList(Arrays.asList(REF_REPO, REF_REFS));
    }
}

