/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import java.util.Optional;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.logic.ImmutableReferencesQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;

@Value.Immutable
public interface ReferencesQuery
extends PageableQuery {
    @Override
    @Value.Parameter(order=1)
    public Optional<PagingToken> pagingToken();

    @Value.Parameter(order=2)
    public Optional<String> referencePrefix();

    @Value.Parameter(order=4)
    public boolean prefetch();

    public static ReferencesQuery referencesQuery() {
        return ReferencesQuery.referencesQuery(null, null, false);
    }

    public static ReferencesQuery referencesQuery(String referencePrefix) {
        return ReferencesQuery.referencesQuery(null, referencePrefix, false);
    }

    public static ReferencesQuery referencesQuery(PagingToken pagingToken, String referencePrefix, boolean prefetch) {
        return ImmutableReferencesQuery.of(Optional.ofNullable(pagingToken), Optional.ofNullable(referencePrefix), prefetch);
    }
}

