/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.persist.ImmutablePreviousPointer;
import org.projectnessie.versioned.storage.common.persist.ImmutableReference;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public interface Reference {
    public static final String INTERNAL_PREFIX = "int/";

    @Value.Parameter(order=2)
    public String name();

    @Value.Parameter(order=3)
    public ObjId pointer();

    @Value.Parameter(order=4)
    public boolean deleted();

    @Value.Parameter(order=5)
    public long createdAtMicros();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=6)
    public ObjId extendedInfoObj();

    @Value.Auxiliary
    @Value.Parameter(order=7)
    public List<PreviousPointer> previousPointers();

    default public Reference forNewPointer(ObjId newPointer, StoreConfig config) {
        ArrayList<PreviousPointer> previous = new ArrayList<PreviousPointer>();
        long now = config.currentTimeMicros();
        int sizeLimit = config.referencePreviousHeadCount();
        long timeLimit = now - TimeUnit.SECONDS.toMicros(config.referencePreviousHeadTimeSpanSeconds());
        if (!newPointer.equals(this.pointer())) {
            previous.add(PreviousPointer.previousPointer(this.pointer(), now));
        }
        for (PreviousPointer previousPointer : this.previousPointers()) {
            if (previous.size() == sizeLimit || previousPointer.timestamp() - timeLimit < 0L) break;
            previous.add(previousPointer);
        }
        return ImmutableReference.builder().from(this).deleted(false).pointer(newPointer).previousPointers(previous).build();
    }

    public Reference withDeleted(boolean var1);

    public static Reference reference(String name, ObjId pointer, boolean deleted, long createdAtMicros, ObjId extendedInfoObj) {
        return Reference.reference(name, pointer, deleted, createdAtMicros, extendedInfoObj, Collections.emptyList());
    }

    public static Reference reference(String name, ObjId pointer, boolean deleted, long createdAtMicros, ObjId extendedInfoObj, List<PreviousPointer> previousPointers) {
        return ImmutableReference.of(name, pointer, deleted, createdAtMicros, extendedInfoObj, previousPointers);
    }

    @Value.NonAttribute
    default public boolean isInternal() {
        return this.name().startsWith(INTERNAL_PREFIX);
    }

    public static boolean isInternalReferenceName(String name) {
        return name.startsWith(INTERNAL_PREFIX);
    }

    @Value.Immutable
    public static interface PreviousPointer {
        @Value.Parameter(order=1)
        public ObjId pointer();

        @Value.Parameter(order=2)
        public long timestamp();

        public static PreviousPointer previousPointer(ObjId pointer, long timestamp) {
            return ImmutablePreviousPointer.of(pointer, timestamp);
        }
    }
}

