/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import java.util.Arrays;
import java.util.List;

public final class Closing {
    private Closing() {
    }

    public static void closeMultiple(AutoCloseable ... closeables) throws Exception {
        Closing.closeMultiple(Arrays.asList(closeables));
    }

    public static void closeMultiple(List<AutoCloseable> closeables) throws Exception {
        Exception ex = null;
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }
}

