/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.logic.SuppliedCommitIndex;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;

public interface IndexesLogic {
    @javax.annotation.Nonnull
    @Nonnull
    public Supplier<SuppliedCommitIndex> createIndexSupplier(@javax.annotation.Nonnull @Nonnull Supplier<ObjId> var1);

    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> buildCompleteIndex(@javax.annotation.Nonnull @Nonnull CommitObj var1, Optional<StoreIndex<CommitOp>> var2);

    @javax.annotation.Nonnull
    @Nonnull
    default public StoreIndex<CommitOp> buildCompleteIndexOrEmpty(@Nullable @jakarta.annotation.Nullable CommitObj commit) {
        return commit != null ? this.buildCompleteIndex(commit, Optional.empty()) : StoreIndexes.emptyImmutableIndex(CommitOp.COMMIT_OP_SERIALIZER);
    }

    @Nullable
    @jakarta.annotation.Nullable
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@javax.annotation.Nonnull @Nonnull CommitObj var1);

    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@javax.annotation.Nonnull @Nonnull ObjId var1, @javax.annotation.Nonnull @Nonnull ObjId var2);

    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexForUpdate(@javax.annotation.Nonnull @Nonnull CommitObj var1, Optional<StoreIndex<CommitOp>> var2);

    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexFromCommit(@javax.annotation.Nonnull @Nonnull CommitObj var1);

    @javax.annotation.Nonnull
    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(@javax.annotation.Nonnull @Nonnull CommitObj var1);

    @javax.annotation.Nonnull
    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(@javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> var1);

    @javax.annotation.Nonnull
    @Nonnull
    public ObjId persistStripedIndex(@javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> var1) throws ObjTooLargeException;

    @javax.annotation.Nonnull
    @Nonnull
    public List<IndexStripe> persistIndexStripesFromIndex(@javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> var1) throws ObjTooLargeException;

    public void completeIndexesInCommitChain(@javax.annotation.Nonnull @Nonnull ObjId var1, Runnable var2) throws ObjNotFoundException;
}

