/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableCommitConflict;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;

@Value.Immutable
public interface CommitConflict {
    @Value.Parameter(order=1)
    public StoreKey key();

    @Value.Parameter(order=2)
    public ConflictType conflictType();

    @Nullable
    @Value.Parameter(order=3)
    public CommitOp op();

    @Nullable
    @Value.Parameter(order=4)
    public CommitOp existing();

    public static CommitConflict commitConflict(StoreKey key, ConflictType conflictType, @Nullable CommitOp op) {
        return CommitConflict.commitConflict(key, conflictType, op, null);
    }

    public static CommitConflict commitConflict(StoreKey key, ConflictType conflictType, @Nullable CommitOp op, @Nullable CommitOp existing) {
        return ImmutableCommitConflict.of(key, conflictType, op, existing);
    }

    public static enum ConflictType {
        KEY_EXISTS,
        KEY_DOES_NOT_EXIST,
        PAYLOAD_DIFFERS,
        CONTENT_ID_DIFFERS,
        VALUE_DIFFERS;

    }
}

