/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.DiffEntry;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DiffEntry", generator="Immutables")
@Immutable
public final class ImmutableDiffEntry
implements DiffEntry {
    private final StoreKey key;
    @jakarta.annotation.Nullable
    private final ObjId fromId;
    private final int fromPayload;
    @jakarta.annotation.Nullable
    private final UUID fromContentId;
    @jakarta.annotation.Nullable
    private final ObjId toId;
    private final int toPayload;
    @jakarta.annotation.Nullable
    private final UUID toContentId;

    private ImmutableDiffEntry(StoreKey key, @jakarta.annotation.Nullable ObjId fromId, int fromPayload, @jakarta.annotation.Nullable UUID fromContentId, @jakarta.annotation.Nullable ObjId toId, int toPayload, @jakarta.annotation.Nullable UUID toContentId) {
        this.key = Objects.requireNonNull(key, "key");
        this.fromId = fromId;
        this.fromPayload = fromPayload;
        this.fromContentId = fromContentId;
        this.toId = toId;
        this.toPayload = toPayload;
        this.toContentId = toContentId;
    }

    private ImmutableDiffEntry(ImmutableDiffEntry original, StoreKey key, @jakarta.annotation.Nullable ObjId fromId, int fromPayload, @jakarta.annotation.Nullable UUID fromContentId, @jakarta.annotation.Nullable ObjId toId, int toPayload, @jakarta.annotation.Nullable UUID toContentId) {
        this.key = key;
        this.fromId = fromId;
        this.fromPayload = fromPayload;
        this.fromContentId = fromContentId;
        this.toId = toId;
        this.toPayload = toPayload;
        this.toContentId = toContentId;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId fromId() {
        return this.fromId;
    }

    @Override
    public int fromPayload() {
        return this.fromPayload;
    }

    @Override
    @jakarta.annotation.Nullable
    public UUID fromContentId() {
        return this.fromContentId;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId toId() {
        return this.toId;
    }

    @Override
    public int toPayload() {
        return this.toPayload;
    }

    @Override
    @jakarta.annotation.Nullable
    public UUID toContentId() {
        return this.toContentId;
    }

    public final ImmutableDiffEntry withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableDiffEntry(this, newValue, this.fromId, this.fromPayload, this.fromContentId, this.toId, this.toPayload, this.toContentId);
    }

    public final ImmutableDiffEntry withFromId(@jakarta.annotation.Nullable ObjId value) {
        if (this.fromId == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, value, this.fromPayload, this.fromContentId, this.toId, this.toPayload, this.toContentId);
    }

    public final ImmutableDiffEntry withFromPayload(int value) {
        if (this.fromPayload == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.fromId, value, this.fromContentId, this.toId, this.toPayload, this.toContentId);
    }

    public final ImmutableDiffEntry withFromContentId(@jakarta.annotation.Nullable UUID value) {
        if (this.fromContentId == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.fromId, this.fromPayload, value, this.toId, this.toPayload, this.toContentId);
    }

    public final ImmutableDiffEntry withToId(@jakarta.annotation.Nullable ObjId value) {
        if (this.toId == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.fromId, this.fromPayload, this.fromContentId, value, this.toPayload, this.toContentId);
    }

    public final ImmutableDiffEntry withToPayload(int value) {
        if (this.toPayload == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.fromId, this.fromPayload, this.fromContentId, this.toId, value, this.toContentId);
    }

    public final ImmutableDiffEntry withToContentId(@jakarta.annotation.Nullable UUID value) {
        if (this.toContentId == value) {
            return this;
        }
        return new ImmutableDiffEntry(this, this.key, this.fromId, this.fromPayload, this.fromContentId, this.toId, this.toPayload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffEntry && this.equalTo(0, (ImmutableDiffEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiffEntry another) {
        return this.key.equals(another.key) && Objects.equals(this.fromId, another.fromId) && this.fromPayload == another.fromPayload && Objects.equals(this.fromContentId, another.fromContentId) && Objects.equals(this.toId, another.toId) && this.toPayload == another.toPayload && Objects.equals(this.toContentId, another.toContentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.fromId);
        h += (h << 5) + this.fromPayload;
        h += (h << 5) + Objects.hashCode(this.fromContentId);
        h += (h << 5) + Objects.hashCode(this.toId);
        h += (h << 5) + this.toPayload;
        h += (h << 5) + Objects.hashCode(this.toContentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffEntry").omitNullValues().add("key", (Object)this.key).add("fromId", (Object)this.fromId).add("fromPayload", this.fromPayload).add("fromContentId", (Object)this.fromContentId).add("toId", (Object)this.toId).add("toPayload", this.toPayload).add("toContentId", (Object)this.toContentId).toString();
    }

    public static ImmutableDiffEntry of(StoreKey key, @jakarta.annotation.Nullable ObjId fromId, int fromPayload, @jakarta.annotation.Nullable UUID fromContentId, @jakarta.annotation.Nullable ObjId toId, int toPayload, @jakarta.annotation.Nullable UUID toContentId) {
        return new ImmutableDiffEntry(key, fromId, fromPayload, fromContentId, toId, toPayload, toContentId);
    }

    public static ImmutableDiffEntry copyOf(DiffEntry instance) {
        if (instance instanceof ImmutableDiffEntry) {
            return (ImmutableDiffEntry)instance;
        }
        return ImmutableDiffEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DiffEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_FROM_PAYLOAD = 2L;
        private static final long INIT_BIT_TO_PAYLOAD = 4L;
        private long initBits = 7L;
        @Nullable
        private StoreKey key;
        @Nullable
        private ObjId fromId;
        private int fromPayload;
        @Nullable
        private UUID fromContentId;
        @Nullable
        private ObjId toId;
        private int toPayload;
        @Nullable
        private UUID toContentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DiffEntry instance) {
            ObjId toIdValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            ObjId fromIdValue = instance.fromId();
            if (fromIdValue != null) {
                this.fromId(fromIdValue);
            }
            this.fromPayload(instance.fromPayload());
            UUID fromContentIdValue = instance.fromContentId();
            if (fromContentIdValue != null) {
                this.fromContentId(fromContentIdValue);
            }
            if ((toIdValue = instance.toId()) != null) {
                this.toId(toIdValue);
            }
            this.toPayload(instance.toPayload());
            UUID toContentIdValue = instance.toContentId();
            if (toContentIdValue != null) {
                this.toContentId(toContentIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromId(@jakarta.annotation.Nullable ObjId fromId) {
            this.fromId = fromId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromPayload(int fromPayload) {
            this.fromPayload = fromPayload;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromContentId(@jakarta.annotation.Nullable UUID fromContentId) {
            this.fromContentId = fromContentId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toId(@jakarta.annotation.Nullable ObjId toId) {
            this.toId = toId;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toPayload(int toPayload) {
            this.toPayload = toPayload;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toContentId(@jakarta.annotation.Nullable UUID toContentId) {
            this.toContentId = toContentId;
            return this;
        }

        public ImmutableDiffEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffEntry(null, this.key, this.fromId, this.fromPayload, this.fromContentId, this.toId, this.toPayload, this.toContentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fromPayload");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("toPayload");
            }
            return "Cannot build DiffEntry, some of required attributes are not set " + attributes;
        }
    }
}

