/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RefObj", generator="Immutables")
@Immutable
public final class ImmutableRefObj
implements RefObj {
    private final String name;
    @jakarta.annotation.Nullable
    private final ObjId id;
    private final ObjId initialPointer;
    private final long createdAtMicros;
    @jakarta.annotation.Nullable
    private final ObjId extendedInfoObj;

    private ImmutableRefObj(String name, @jakarta.annotation.Nullable ObjId id, ObjId initialPointer, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        this.name = Objects.requireNonNull(name, "name");
        this.id = id;
        this.initialPointer = Objects.requireNonNull(initialPointer, "initialPointer");
        this.createdAtMicros = createdAtMicros;
        this.extendedInfoObj = extendedInfoObj;
    }

    private ImmutableRefObj(ImmutableRefObj original, String name, @jakarta.annotation.Nullable ObjId id, ObjId initialPointer, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        this.name = name;
        this.id = id;
        this.initialPointer = initialPointer;
        this.createdAtMicros = createdAtMicros;
        this.extendedInfoObj = extendedInfoObj;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public ObjId initialPointer() {
        return this.initialPointer;
    }

    @Override
    public long createdAtMicros() {
        return this.createdAtMicros;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId extendedInfoObj() {
        return this.extendedInfoObj;
    }

    public final ImmutableRefObj withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRefObj(this, newValue, this.id, this.initialPointer, this.createdAtMicros, this.extendedInfoObj);
    }

    public final ImmutableRefObj withId(@jakarta.annotation.Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableRefObj(this, this.name, value, this.initialPointer, this.createdAtMicros, this.extendedInfoObj);
    }

    public final ImmutableRefObj withInitialPointer(ObjId value) {
        if (this.initialPointer == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "initialPointer");
        return new ImmutableRefObj(this, this.name, this.id, newValue, this.createdAtMicros, this.extendedInfoObj);
    }

    public final ImmutableRefObj withCreatedAtMicros(long value) {
        if (this.createdAtMicros == value) {
            return this;
        }
        return new ImmutableRefObj(this, this.name, this.id, this.initialPointer, value, this.extendedInfoObj);
    }

    public final ImmutableRefObj withExtendedInfoObj(@jakarta.annotation.Nullable ObjId value) {
        if (this.extendedInfoObj == value) {
            return this;
        }
        return new ImmutableRefObj(this, this.name, this.id, this.initialPointer, this.createdAtMicros, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRefObj && this.equalTo(0, (ImmutableRefObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableRefObj another) {
        return this.name.equals(another.name) && Objects.equals(this.id, another.id) && this.initialPointer.equals(another.initialPointer) && this.createdAtMicros == another.createdAtMicros && Objects.equals(this.extendedInfoObj, another.extendedInfoObj);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.initialPointer.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.createdAtMicros);
        h += (h << 5) + Objects.hashCode(this.extendedInfoObj);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RefObj").omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("initialPointer", (Object)this.initialPointer).add("createdAtMicros", this.createdAtMicros).add("extendedInfoObj", (Object)this.extendedInfoObj).toString();
    }

    public static ImmutableRefObj of(String name, @jakarta.annotation.Nullable ObjId id, ObjId initialPointer, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        return new ImmutableRefObj(name, id, initialPointer, createdAtMicros, extendedInfoObj);
    }

    public static ImmutableRefObj copyOf(RefObj instance) {
        if (instance instanceof ImmutableRefObj) {
            return (ImmutableRefObj)instance;
        }
        return ImmutableRefObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RefObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_INITIAL_POINTER = 2L;
        private static final long INIT_BIT_CREATED_AT_MICROS = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        @Nullable
        private ObjId id;
        @Nullable
        private ObjId initialPointer;
        private long createdAtMicros;
        @Nullable
        private ObjId extendedInfoObj;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RefObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof RefObj) {
                instance = (RefObj)object;
                this.name(instance.name());
                ObjId extendedInfoObjValue = instance.extendedInfoObj();
                if (extendedInfoObjValue != null) {
                    this.extendedInfoObj(extendedInfoObjValue);
                }
                if ((bits & 1L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
                this.createdAtMicros(instance.createdAtMicros());
                this.initialPointer(instance.initialPointer());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(@jakarta.annotation.Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initialPointer(ObjId initialPointer) {
            this.initialPointer = Objects.requireNonNull(initialPointer, "initialPointer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdAtMicros(long createdAtMicros) {
            this.createdAtMicros = createdAtMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extendedInfoObj(@jakarta.annotation.Nullable ObjId extendedInfoObj) {
            this.extendedInfoObj = extendedInfoObj;
            return this;
        }

        public ImmutableRefObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRefObj(null, this.name, this.id, this.initialPointer, this.createdAtMicros, this.extendedInfoObj);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("initialPointer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAtMicros");
            }
            return "Cannot build RefObj, some of required attributes are not set " + attributes;
        }
    }
}

