/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nullable;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableStringObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface StringObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.STRING;
    }

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public String contentType();

    @Value.Parameter(order=3)
    public Compression compression();

    @Nullable
    @Value.Parameter(order=4)
    public String filename();

    @Value.Parameter(order=5)
    public List<ObjId> predecessors();

    @Value.Parameter(order=6)
    public ByteString text();

    public static StringObj stringData(ObjId id, String contentType, Compression compression, @Nullable String filename, List<ObjId> predecessors, ByteString text) {
        return ImmutableStringObj.of(id, contentType, compression, filename, predecessors, text);
    }

    public static StringObj stringData(String contentType, Compression compression, @Nullable String filename, List<ObjId> predecessors, ByteString text) {
        return StringObj.stringData(Hashes.stringDataHash(contentType, compression, filename, predecessors, text), contentType, compression, filename, predecessors, text);
    }
}

