/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.ObjTypeBundle;

public final class ObjTypes {
    @Nonnull
    public static Set<ObjType> allObjTypes() {
        return Registry.OBJ_TYPES;
    }

    @Nonnull
    public static ObjType forName(@Nonnull String name) {
        ObjType type = Registry.BY_NAME.get(name);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown object type name: %s", (Object)name);
        return type;
    }

    @Nonnull
    public static ObjType forShortName(@Nonnull String shortName) {
        ObjType type = Registry.BY_SHORT_NAME.get(shortName);
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown object type short name: %s", (Object)shortName);
        return type;
    }

    private static final class Registry {
        private static final Map<String, ObjType> BY_NAME;
        private static final Map<String, ObjType> BY_SHORT_NAME;
        private static final Set<ObjType> OBJ_TYPES;

        private Registry() {
        }

        static {
            TreeMap byName = new TreeMap();
            HashMap byShortName = new HashMap();
            for (ObjTypeBundle bundle : ServiceLoader.load(ObjTypeBundle.class)) {
                bundle.register(objType -> {
                    if (byName.put(objType.name(), objType) != null) {
                        throw new IllegalStateException("Duplicate object type name: " + objType.name());
                    }
                    if (byShortName.put(objType.shortName(), objType) != null) {
                        throw new IllegalStateException("Duplicate object type short name: " + objType.shortName());
                    }
                });
            }
            BY_NAME = Collections.unmodifiableMap(byName);
            BY_SHORT_NAME = Collections.unmodifiableMap(byShortName);
            OBJ_TYPES = Set.copyOf(byName.values());
        }
    }
}

