/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.exceptions;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.versioned.storage.common.persist.ObjId;

public class ObjNotFoundException
extends Exception {
    private final ObjId[] objIds;

    public ObjNotFoundException(@Nonnull ObjId objId) {
        super("Object with ID " + objId + " not found");
        this.objIds = new ObjId[]{objId};
    }

    public ObjNotFoundException(@Nonnull List<ObjId> objIds) {
        super(objIds.size() == 1 ? "Object with ID " + objIds.get(0) + " not found" : "Objects with IDs " + objIds.stream().map(ObjId::toString).collect(Collectors.joining(",")) + " not found");
        this.objIds = objIds.toArray(new ObjId[0]);
    }

    public List<ObjId> objIds() {
        return Arrays.asList(this.objIds);
    }
}

