/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.logic.ImmutableCommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public interface CommitLogQuery
extends PageableQuery {
    @Override
    @Value.Parameter(order=1)
    public Optional<PagingToken> pagingToken();

    @Value.Parameter(order=2)
    public ObjId commitId();

    @Value.Parameter(order=3)
    public Optional<ObjId> endCommitId();

    @Nonnull
    public static CommitLogQuery commitLogQuery(@Nonnull ObjId commitId) {
        return CommitLogQuery.commitLogQuery(null, commitId, null);
    }

    @Nonnull
    public static CommitLogQuery commitLogQuery(@Nullable PagingToken pagingToken, @Nonnull ObjId commitId, @Nullable ObjId endCommitId) {
        return ImmutableCommitLogQuery.of(Optional.ofNullable(pagingToken), commitId, Optional.ofNullable(endCommitId));
    }
}

