/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.ConsistencyLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConsistencyLogic.CommitStatus", generator="Immutables")
@Immutable
public final class ImmutableCommitStatus
implements ConsistencyLogic.CommitStatus {
    private final ObjId id;
    @jakarta.annotation.Nullable
    private final CommitObj commit;
    private final boolean indexObjectsAvailable;
    private final boolean contentObjectsAvailable;

    private ImmutableCommitStatus(ObjId id, @jakarta.annotation.Nullable CommitObj commit, boolean indexObjectsAvailable, boolean contentObjectsAvailable) {
        this.id = Objects.requireNonNull(id, "id");
        this.commit = commit;
        this.indexObjectsAvailable = indexObjectsAvailable;
        this.contentObjectsAvailable = contentObjectsAvailable;
    }

    private ImmutableCommitStatus(ImmutableCommitStatus original, ObjId id, @jakarta.annotation.Nullable CommitObj commit, boolean indexObjectsAvailable, boolean contentObjectsAvailable) {
        this.id = id;
        this.commit = commit;
        this.indexObjectsAvailable = indexObjectsAvailable;
        this.contentObjectsAvailable = contentObjectsAvailable;
    }

    @Override
    public ObjId id() {
        return this.id;
    }

    @Override
    @jakarta.annotation.Nullable
    public CommitObj commit() {
        return this.commit;
    }

    @Override
    public boolean indexObjectsAvailable() {
        return this.indexObjectsAvailable;
    }

    @Override
    public boolean contentObjectsAvailable() {
        return this.contentObjectsAvailable;
    }

    public final ImmutableCommitStatus withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableCommitStatus(this, newValue, this.commit, this.indexObjectsAvailable, this.contentObjectsAvailable);
    }

    public final ImmutableCommitStatus withCommit(@jakarta.annotation.Nullable CommitObj value) {
        if (this.commit == value) {
            return this;
        }
        return new ImmutableCommitStatus(this, this.id, value, this.indexObjectsAvailable, this.contentObjectsAvailable);
    }

    public final ImmutableCommitStatus withIndexObjectsAvailable(boolean value) {
        if (this.indexObjectsAvailable == value) {
            return this;
        }
        return new ImmutableCommitStatus(this, this.id, this.commit, value, this.contentObjectsAvailable);
    }

    public final ImmutableCommitStatus withContentObjectsAvailable(boolean value) {
        if (this.contentObjectsAvailable == value) {
            return this;
        }
        return new ImmutableCommitStatus(this, this.id, this.commit, this.indexObjectsAvailable, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitStatus && this.equalTo(0, (ImmutableCommitStatus)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitStatus another) {
        return this.id.equals(another.id) && Objects.equals(this.commit, another.commit) && this.indexObjectsAvailable == another.indexObjectsAvailable && this.contentObjectsAvailable == another.contentObjectsAvailable;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.commit);
        h += (h << 5) + Booleans.hashCode((boolean)this.indexObjectsAvailable);
        h += (h << 5) + Booleans.hashCode((boolean)this.contentObjectsAvailable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitStatus").omitNullValues().add("id", (Object)this.id).add("commit", (Object)this.commit).add("indexObjectsAvailable", this.indexObjectsAvailable).add("contentObjectsAvailable", this.contentObjectsAvailable).toString();
    }

    public static ImmutableCommitStatus of(ObjId id, @jakarta.annotation.Nullable CommitObj commit, boolean indexObjectsAvailable, boolean contentObjectsAvailable) {
        return new ImmutableCommitStatus(id, commit, indexObjectsAvailable, contentObjectsAvailable);
    }

    public static ImmutableCommitStatus copyOf(ConsistencyLogic.CommitStatus instance) {
        if (instance instanceof ImmutableCommitStatus) {
            return (ImmutableCommitStatus)instance;
        }
        return ImmutableCommitStatus.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConsistencyLogic.CommitStatus", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_INDEX_OBJECTS_AVAILABLE = 2L;
        private static final long INIT_BIT_CONTENT_OBJECTS_AVAILABLE = 4L;
        private long initBits = 7L;
        @Nullable
        private ObjId id;
        @Nullable
        private CommitObj commit;
        private boolean indexObjectsAvailable;
        private boolean contentObjectsAvailable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ConsistencyLogic.CommitStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            CommitObj commitValue = instance.commit();
            if (commitValue != null) {
                this.commit(commitValue);
            }
            this.indexObjectsAvailable(instance.indexObjectsAvailable());
            this.contentObjectsAvailable(instance.contentObjectsAvailable());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commit(@jakarta.annotation.Nullable CommitObj commit) {
            this.commit = commit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder indexObjectsAvailable(boolean indexObjectsAvailable) {
            this.indexObjectsAvailable = indexObjectsAvailable;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentObjectsAvailable(boolean contentObjectsAvailable) {
            this.contentObjectsAvailable = contentObjectsAvailable;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableCommitStatus build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitStatus(null, this.id, this.commit, this.indexObjectsAvailable, this.contentObjectsAvailable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("indexObjectsAvailable");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("contentObjectsAvailable");
            }
            return "Cannot build CommitStatus, some of required attributes are not set " + attributes;
        }
    }
}

