/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.StringLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;

final class StringLogicImpl
implements StringLogic {
    private final Persist persist;

    StringLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    public StringLogic.StringValue fetchString(ObjId stringObjId) throws ObjNotFoundException {
        return this.fetchString(this.persist.fetchTypedObj(stringObjId, StandardObjType.STRING, StringObj.class));
    }

    @Override
    public StringLogic.StringValue fetchString(StringObj stringObj) {
        Preconditions.checkState((stringObj.compression() == Compression.NONE ? 1 : 0) != 0, (String)"Unsupported compression %s", (Object)((Object)stringObj.compression()));
        Preconditions.checkState((boolean)stringObj.predecessors().isEmpty(), (Object)"Predecessors in StringObj are not yet supported");
        return new StringValueHolder(stringObj);
    }

    @Override
    public StringObj updateString(StringLogic.StringValue previousValue, String contentType, byte[] stringValueUtf8) {
        ByteString text = UnsafeByteOperations.unsafeWrap((byte[])stringValueUtf8);
        return StringObj.stringData(contentType, Compression.NONE, null, Collections.emptyList(), text);
    }

    @Override
    public StringObj updateString(StringLogic.StringValue previousValue, String contentType, String stringValue) {
        return this.updateString(previousValue, contentType, stringValue.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public StringLogic.StringValue updateStringOnRef(Reference reference, StoreKey storeKey, Consumer<CreateCommit.Builder> commitEnhancer, String contentType, byte[] stringValueUtf8) throws ObjNotFoundException, CommitConflictException, RefNotFoundException, RefConditionFailedException {
        CommitLogic commitLogic = Logics.commitLogic(this.persist);
        IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
        CommitObj head = commitLogic.headCommit(reference);
        StoreIndex<CommitOp> index = indexesLogic.buildCompleteIndexOrEmpty(head);
        StoreIndexElement<CommitOp> existingElement = index.get(storeKey);
        ObjId existingValueId = null;
        UUID contentId = null;
        if (existingElement != null) {
            CommitOp op = existingElement.content();
            if (op.action().exists()) {
                existingValueId = op.value();
                contentId = op.contentId();
            }
        } else {
            contentId = UUID.randomUUID();
        }
        StringLogic.StringValue existing = existingValueId != null ? this.fetchString(existingValueId) : null;
        StringObj newValue = this.updateString(existing, contentType, stringValueUtf8);
        ObjId newValueId = Objects.requireNonNull(newValue.id());
        if (!newValueId.equals(existingValueId)) {
            CreateCommit.Builder builder = CreateCommit.newCommitBuilder().parentCommitId(reference.pointer()).headers(CommitHeaders.EMPTY_COMMIT_HEADERS).addAdds(CreateCommit.Add.commitAdd(storeKey, 0, newValueId, existingValueId, contentId));
            commitEnhancer.accept(builder);
            CommitObj committed = commitLogic.doCommit(builder.build(), Collections.singletonList(newValue));
            this.persist.updateReferencePointer(reference, Objects.requireNonNull(committed).id());
        }
        return existing;
    }

    static final class StringValueHolder
    implements StringLogic.StringValue {
        final StringObj obj;

        StringValueHolder(StringObj obj) {
            this.obj = obj;
        }

        @Override
        public String contentType() {
            return this.obj.contentType();
        }

        @Override
        public String completeValue() throws ObjNotFoundException {
            return this.obj.text().toStringUtf8();
        }

        @Override
        public ObjId objId() {
            return this.obj.id();
        }
    }
}

